/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.compute.lucene;

import java.util.List;
import java.util.function.Function;
import org.apache.lucene.search.ScoreMode;
import org.elasticsearch.compute.lucene.DataPartitioning;
import org.elasticsearch.compute.lucene.LuceneOperator;
import org.elasticsearch.compute.lucene.LuceneSliceQueue;
import org.elasticsearch.compute.lucene.ShardContext;
import org.elasticsearch.compute.lucene.TimeSeriesSourceOperator;
import org.elasticsearch.compute.operator.DriverContext;
import org.elasticsearch.compute.operator.SourceOperator;

public class TimeSeriesSourceOperatorFactory
extends LuceneOperator.Factory {
    private final List<? extends ShardContext> contexts;
    private final int maxPageSize;

    private TimeSeriesSourceOperatorFactory(List<? extends ShardContext> contexts, Function<ShardContext, List<LuceneSliceQueue.QueryAndTags>> queryFunction, int taskConcurrency, int maxPageSize, int limit) {
        super(contexts, queryFunction, DataPartitioning.SHARD, query -> {
            throw new UnsupportedOperationException("locked to SHARD partitioning");
        }, taskConcurrency, limit, false, shardContext -> ScoreMode.COMPLETE_NO_SCORES);
        this.contexts = contexts;
        this.maxPageSize = maxPageSize;
    }

    @Override
    public SourceOperator get(DriverContext driverContext) {
        return new TimeSeriesSourceOperator(this.contexts, driverContext.blockFactory(), this.sliceQueue, this.maxPageSize, this.limit);
    }

    @Override
    public String describe() {
        return "TimeSeriesSourceOperator[maxPageSize = " + this.maxPageSize + ", limit = " + this.limit + "]";
    }

    public static TimeSeriesSourceOperatorFactory create(int limit, int maxPageSize, int taskConcurrency, List<? extends ShardContext> contexts, Function<ShardContext, List<LuceneSliceQueue.QueryAndTags>> queryFunction) {
        return new TimeSeriesSourceOperatorFactory(contexts, queryFunction, taskConcurrency, maxPageSize, limit);
    }
}

