/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.enrich.action;

import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.AutoCreateIndex;
import org.elasticsearch.client.internal.Client;
import org.elasticsearch.client.internal.OriginSettingClient;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.project.ProjectResolver;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.util.concurrent.ThreadContext;
import org.elasticsearch.env.Environment;
import org.elasticsearch.index.reindex.ReindexRequest;
import org.elasticsearch.injection.guice.Inject;
import org.elasticsearch.reindex.ReindexSslConfig;
import org.elasticsearch.reindex.TransportReindexAction;
import org.elasticsearch.script.ScriptService;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.watcher.ResourceWatcherService;

public class TransportEnrichReindexAction
extends TransportReindexAction {
    private final Client bulkClient;

    @Inject
    public TransportEnrichReindexAction(Settings settings, ThreadPool threadPool, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver, ProjectResolver projectResolver, ClusterService clusterService, ScriptService scriptService, AutoCreateIndex autoCreateIndex, Client client, TransportService transportService, Environment environment, ResourceWatcherService watcherService) {
        super("cluster:admin/xpack/enrich/reindex", settings, threadPool, actionFilters, indexNameExpressionResolver, projectResolver, clusterService, scriptService, autoCreateIndex, client, transportService, new ReindexSslConfig(settings, environment, watcherService), null);
        this.bulkClient = new OriginSettingClient(client, "enrich");
    }

    protected Client getBulkClient() {
        return this.bulkClient;
    }

    protected void validate(ReindexRequest request) {
        try (ThreadContext.StoredContext ctx = this.client.threadPool().getThreadContext().stashWithOrigin("enrich");){
            this.reindexValidator.initialValidation(request);
        }
    }
}

