/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.rest.streams.logs;

import java.io.IOException;
import java.util.Map;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.support.TransportAction;
import org.elasticsearch.action.support.local.LocalClusterStateRequest;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.tasks.CancellableTask;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.tasks.TaskId;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentObject;
import org.elasticsearch.xcontent.XContentBuilder;

public class StreamsStatusAction {
    public static ActionType<Response> INSTANCE = new ActionType("cluster:monitor/streams/status");

    public static class Response
    extends ActionResponse
    implements ToXContentObject {
        private final boolean logs_enabled;

        public Response(boolean logsEnabled) {
            this.logs_enabled = logsEnabled;
        }

        public void writeTo(StreamOutput out) throws IOException {
            TransportAction.localOnly();
        }

        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject();
            builder.startObject("logs");
            builder.field("enabled", this.logs_enabled);
            builder.endObject();
            builder.endObject();
            return builder;
        }
    }

    public static class Request
    extends LocalClusterStateRequest {
        protected Request(TimeValue masterTimeout) {
            super(masterTimeout);
        }

        public Task createTask(long id, String type, String action, TaskId parentTaskId, Map<String, String> headers) {
            return new CancellableTask(id, type, action, "Streams status request", parentTaskId, headers);
        }
    }
}

