/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.entitlement.runtime.policy;

public class FileUtils {
    private FileUtils() {
    }

    public static boolean isAbsolutePath(String path) {
        if (path.isEmpty()) {
            return false;
        }
        if (path.charAt(0) == '/') {
            return true;
        }
        return FileUtils.isWindowsAbsolutePath(path);
    }

    static boolean isSlash(char c) {
        return c == '\\' || c == '/';
    }

    private static boolean isWindowsAbsolutePath(String input) {
        if (input.startsWith("\\\\?\\")) {
            return true;
        }
        if (input.length() > 1) {
            char c0 = input.charAt(0);
            char c1 = input.charAt(1);
            if (FileUtils.isSlash(c0) && FileUtils.isSlash(c1)) {
                return true;
            }
            if (Character.isLetter(c0) && c1 == ':') {
                return true;
            }
        }
        return false;
    }
}

