/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.transport;

import org.elasticsearch.core.Nullable;
import org.elasticsearch.core.TimeValue;

public class TransportRequestOptions {
    @Nullable
    private final TimeValue timeout;
    private final Type type;
    public static final TransportRequestOptions EMPTY = new TransportRequestOptions(null, Type.REG);

    public static TransportRequestOptions timeout(@Nullable TimeValue timeout) {
        return TransportRequestOptions.of(timeout, Type.REG);
    }

    public static TransportRequestOptions of(@Nullable TimeValue timeout, Type type) {
        if (timeout == null && type == Type.REG) {
            return EMPTY;
        }
        return new TransportRequestOptions(timeout, type);
    }

    private TransportRequestOptions(@Nullable TimeValue timeout, Type type) {
        this.timeout = timeout;
        this.type = type;
    }

    @Nullable
    public TimeValue timeout() {
        return this.timeout;
    }

    public Type type() {
        return this.type;
    }

    public static enum Type {
        RECOVERY,
        BULK,
        REG,
        STATE,
        PING;

    }
}

