/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.transport;

import java.io.IOException;
import java.util.ArrayDeque;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.common.bytes.BytesArray;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.bytes.ReleasableBytesReference;
import org.elasticsearch.common.recycler.Recycler;
import org.elasticsearch.core.Releasable;
import org.elasticsearch.transport.Compression;
import org.elasticsearch.transport.DeflateTransportDecompressor;
import org.elasticsearch.transport.Lz4TransportDecompressor;

public abstract class TransportDecompressor
implements Releasable {
    protected int pageOffset = 0;
    protected int pageLength = 0;
    protected boolean hasSkippedHeader = false;
    protected final ArrayDeque<Recycler.V<BytesRef>> pages = new ArrayDeque(4);
    private final Recycler<BytesRef> recycler;

    protected TransportDecompressor(Recycler<BytesRef> recycler) {
        this.recycler = recycler;
    }

    public abstract int decompress(BytesReference var1) throws IOException;

    public ReleasableBytesReference pollDecompressedPage(boolean isEOS) {
        if (this.pages.isEmpty()) {
            return null;
        }
        if (this.pages.size() == 1) {
            if (isEOS) {
                return this.pollLastPage();
            }
            return null;
        }
        Recycler.V<BytesRef> page = this.pages.pollFirst();
        return new ReleasableBytesReference((BytesReference)new BytesArray(page.v()), page);
    }

    public abstract Compression.Scheme getScheme();

    public void close() {
        for (Recycler.V<BytesRef> page : this.pages) {
            page.close();
        }
    }

    static TransportDecompressor getDecompressor(Recycler<BytesRef> recycler, BytesReference bytes) {
        if (bytes.length() < 4) {
            return null;
        }
        if (Compression.Scheme.isDeflate(bytes)) {
            return new DeflateTransportDecompressor(recycler);
        }
        if (Compression.Scheme.isLZ4(bytes)) {
            return new Lz4TransportDecompressor(recycler);
        }
        throw TransportDecompressor.createIllegalState(bytes);
    }

    protected ReleasableBytesReference pollLastPage() {
        Recycler.V<BytesRef> page = this.pages.pollFirst();
        BytesArray delegate = new BytesArray(page.v().bytes, page.v().offset, this.pageOffset);
        ReleasableBytesReference reference = new ReleasableBytesReference((BytesReference)delegate, page);
        this.pageLength = 0;
        this.pageOffset = 0;
        return reference;
    }

    protected boolean maybeAddNewPage() {
        if (this.pageOffset == this.pageLength) {
            Recycler.V<BytesRef> newPage = this.recycler.obtain();
            this.pageOffset = 0;
            this.pageLength = newPage.v().length;
            assert (newPage.v().length > 0);
            this.pages.add(newPage);
            return true;
        }
        return false;
    }

    private static IllegalStateException createIllegalState(BytesReference bytes) {
        int maxToRead = Math.min(bytes.length(), 10);
        StringBuilder sb = new StringBuilder("stream marked as compressed, but no compressor found, first [").append(maxToRead).append("] content bytes out of [").append(bytes.length()).append("] readable bytes with message size [").append(bytes.length()).append("] ").append("] are [");
        for (int i = 0; i < maxToRead; ++i) {
            sb.append(bytes.get(i)).append(",");
        }
        sb.append("]");
        return new IllegalStateException(sb.toString());
    }
}

