/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.snapshots;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.elasticsearch.cluster.SnapshotsInProgress;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.repositories.IndexId;
import org.elasticsearch.repositories.RepositoryOperation;
import org.elasticsearch.repositories.RepositoryShardId;
import org.elasticsearch.repositories.ShardGeneration;
import org.elasticsearch.repositories.ShardGenerations;

public final class InFlightShardSnapshotStates {
    private static final InFlightShardSnapshotStates EMPTY = new InFlightShardSnapshotStates(Map.of(), Map.of());
    private final Map<String, Map<Integer, ShardGeneration>> generations;
    private final Map<String, Set<Integer>> activeShardIds;

    public static InFlightShardSnapshotStates forEntries(List<SnapshotsInProgress.Entry> snapshots) {
        if (snapshots.isEmpty()) {
            return EMPTY;
        }
        HashMap<String, Map<Integer, ShardGeneration>> generations = new HashMap<String, Map<Integer, ShardGeneration>>();
        HashMap<String, Set<Integer>> busyIds = new HashMap<String, Set<Integer>>();
        assert (snapshots.stream().map(entry -> new RepositoryOperation.ProjectRepo(entry.projectId(), entry.repository())).distinct().count() == 1L) : "snapshots must either be an empty list or all belong to the same repository but saw " + String.valueOf(snapshots);
        for (SnapshotsInProgress.Entry runningSnapshot : snapshots) {
            for (Map.Entry<RepositoryShardId, SnapshotsInProgress.ShardSnapshotStatus> shard : runningSnapshot.shardSnapshotStatusByRepoShardId().entrySet()) {
                RepositoryShardId sid = shard.getKey();
                InFlightShardSnapshotStates.addStateInformation(generations, busyIds, shard.getValue(), sid.shardId(), sid.indexName());
            }
        }
        return new InFlightShardSnapshotStates(generations, busyIds);
    }

    private static void addStateInformation(Map<String, Map<Integer, ShardGeneration>> generations, Map<String, Set<Integer>> busyIds, SnapshotsInProgress.ShardSnapshotStatus shardState, int shardId, String indexName) {
        if (shardState.isActive()) {
            busyIds.computeIfAbsent(indexName, k -> new HashSet()).add(shardId);
            assert (InFlightShardSnapshotStates.assertGenerationConsistency(generations, indexName, shardId, shardState.generation()));
        } else if (shardState.state() == SnapshotsInProgress.ShardState.SUCCESS) {
            assert (!busyIds.getOrDefault(indexName, Collections.emptySet()).contains(shardId)) : "Can't have a successful operation queued after an in-progress operation";
            generations.computeIfAbsent(indexName, k -> new HashMap()).put(shardId, shardState.generation());
        }
    }

    private InFlightShardSnapshotStates(Map<String, Map<Integer, ShardGeneration>> generations, Map<String, Set<Integer>> activeShardIds) {
        this.generations = generations;
        this.activeShardIds = activeShardIds;
    }

    private static boolean assertGenerationConsistency(Map<String, Map<Integer, ShardGeneration>> generations, String indexName, int shardId, @Nullable ShardGeneration activeGeneration) {
        ShardGeneration bestGeneration = (ShardGeneration)generations.getOrDefault(indexName, Collections.emptyMap()).get(shardId);
        assert (bestGeneration == null || activeGeneration == null || activeGeneration.equals(bestGeneration)) : "[" + indexName + "][" + shardId + "]: " + String.valueOf(bestGeneration) + " vs " + String.valueOf(activeGeneration);
        return true;
    }

    boolean isActive(String indexName, int shardId) {
        return this.activeShardIds.getOrDefault(indexName, Collections.emptySet()).contains(shardId);
    }

    @Nullable
    ShardGeneration generationForShard(IndexId indexId, int shardId, ShardGenerations shardGenerations) {
        ShardGeneration inFlightBest = (ShardGeneration)this.generations.getOrDefault(indexId.getName(), Collections.emptyMap()).get(shardId);
        if (inFlightBest != null) {
            return inFlightBest;
        }
        return shardGenerations.getShardGen(indexId, shardId);
    }
}

