/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.vectors;

import org.apache.lucene.search.Query;
import org.apache.lucene.search.TopDocs;
import org.apache.lucene.search.join.BitSetProducer;
import org.apache.lucene.search.join.DiversifyingChildrenByteKnnVectorQuery;
import org.apache.lucene.search.knn.KnnSearchStrategy;
import org.elasticsearch.search.profile.query.QueryProfiler;
import org.elasticsearch.search.vectors.QueryProfilerProvider;

public class ESDiversifyingChildrenByteKnnVectorQuery
extends DiversifyingChildrenByteKnnVectorQuery
implements QueryProfilerProvider {
    private final int kParam;
    private long vectorOpsCount;

    public ESDiversifyingChildrenByteKnnVectorQuery(String field, byte[] query, Query childFilter, int k, int numCands, BitSetProducer parentsFilter, KnnSearchStrategy strategy) {
        super(field, query, childFilter, numCands, parentsFilter, strategy);
        this.kParam = k;
    }

    protected TopDocs mergeLeafResults(TopDocs[] perLeafResults) {
        TopDocs topK = TopDocs.merge((int)this.kParam, (TopDocs[])perLeafResults);
        this.vectorOpsCount = topK.totalHits.value();
        return topK;
    }

    @Override
    public void profile(QueryProfiler queryProfiler) {
        queryProfiler.addVectorOpsCount(this.vectorOpsCount);
    }

    public KnnSearchStrategy getStrategy() {
        return this.searchStrategy;
    }
}

