/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.runtime;

import java.util.Objects;
import org.elasticsearch.script.DoubleFieldScript;
import org.elasticsearch.script.Script;
import org.elasticsearch.search.runtime.AbstractDoubleScriptFieldQuery;

public class DoubleScriptFieldTermQuery
extends AbstractDoubleScriptFieldQuery {
    private final double term;

    public DoubleScriptFieldTermQuery(Script script, DoubleFieldScript.LeafFactory leafFactory, String fieldName, double term) {
        super(script, leafFactory, fieldName);
        this.term = term;
    }

    @Override
    protected boolean matches(double[] values, int count) {
        for (int i = 0; i < count; ++i) {
            if (this.term != values[i]) continue;
            return true;
        }
        return false;
    }

    public final String toString(String field) {
        if (this.fieldName().contentEquals(field)) {
            return Double.toString(this.term);
        }
        return this.fieldName() + ":" + this.term;
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.term);
    }

    @Override
    public boolean equals(Object obj) {
        if (!super.equals(obj)) {
            return false;
        }
        DoubleScriptFieldTermQuery other = (DoubleScriptFieldTermQuery)((Object)obj);
        return this.term == other.term;
    }

    double term() {
        return this.term;
    }
}

