/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.profile.query;

import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.lucene.sandbox.search.ProfilerCollector;
import org.apache.lucene.sandbox.search.ProfilerCollectorResult;
import org.apache.lucene.search.Collector;
import org.apache.lucene.search.CollectorManager;
import org.elasticsearch.search.profile.query.CollectorResult;
import org.elasticsearch.search.profile.query.InternalProfileCollector;

public final class ProfileCollectorManager<T>
implements CollectorManager<InternalProfileCollector, T> {
    private final CollectorManager<? extends Collector, T> collectorManager;
    private final String reason;
    private CollectorResult collectorTree;

    public ProfileCollectorManager(CollectorManager<? extends Collector, T> collectorManager, String reason) {
        this.collectorManager = collectorManager;
        this.reason = reason;
    }

    public InternalProfileCollector newCollector() throws IOException {
        return new InternalProfileCollector(this.collectorManager.newCollector(), this.reason, new InternalProfileCollector[0]);
    }

    public T reduce(Collection<InternalProfileCollector> profileCollectors) throws IOException {
        assert (profileCollectors.size() > 0) : "at least one collector expected";
        List<Collector> unwrapped = profileCollectors.stream().map(InternalProfileCollector::getWrappedCollector).toList();
        CollectorManager<? extends Collector, T> cm = this.collectorManager;
        Object returnValue = cm.reduce(unwrapped);
        List<CollectorResult> resultsPerProfiler = profileCollectors.stream().map(InternalProfileCollector::getCollectorTree).toList();
        long totalTime = resultsPerProfiler.stream().map(ProfilerCollectorResult::getTime).reduce(0L, Long::sum);
        String collectorName = resultsPerProfiler.get(0).getName();
        assert (profileCollectors.stream().map(ProfilerCollector::getReason).allMatch(this.reason::equals));
        assert (profileCollectors.stream().map(ProfilerCollector::getName).allMatch(collectorName::equals));
        this.collectorTree = new CollectorResult(collectorName, this.reason, totalTime, Collections.emptyList());
        return (T)returnValue;
    }

    public CollectorResult getCollectorTree() {
        if (this.collectorTree == null) {
            throw new IllegalStateException("A collectorTree hasn't been set yet. Call reduce() before attempting to retrieve it");
        }
        return this.collectorTree;
    }
}

