/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.aggregations.bucket.composite;

import java.io.IOException;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.SortedNumericDocValues;
import org.elasticsearch.common.Rounding;
import org.elasticsearch.common.util.BigArrays;
import org.elasticsearch.core.CheckedFunction;
import org.elasticsearch.index.mapper.MappedFieldType;
import org.elasticsearch.search.DocValueFormat;
import org.elasticsearch.search.aggregations.bucket.composite.LongValuesSource;
import org.elasticsearch.search.aggregations.bucket.composite.MissingOrder;
import org.elasticsearch.search.aggregations.bucket.composite.RoundingValuesSource;
import org.elasticsearch.search.aggregations.bucket.histogram.SizedBucketAggregator;

public class DateHistogramValuesSource
extends LongValuesSource
implements SizedBucketAggregator {
    private final RoundingValuesSource preparedRounding;

    DateHistogramValuesSource(BigArrays bigArrays, MappedFieldType fieldType, RoundingValuesSource roundingValuesSource, DocValueFormat format, boolean missingBucket, MissingOrder missingOrder, int size, int reverseMul) {
        super(bigArrays, fieldType, (CheckedFunction<LeafReaderContext, SortedNumericDocValues, IOException>)((CheckedFunction)roundingValuesSource::longValues), roundingValuesSource::round, format, missingBucket, missingOrder, size, reverseMul);
        this.preparedRounding = roundingValuesSource;
    }

    @Override
    public double bucketSize(long bucket, Rounding.DateTimeUnit unitSize) {
        if (unitSize != null) {
            Long value = this.toComparable((int)bucket);
            assert (value != null) : "unexpected null value in composite agg bucket [" + (int)bucket + "]";
            return this.preparedRounding.roundingSize(value, unitSize);
        }
        return 1.0;
    }

    @Override
    public double bucketSize(Rounding.DateTimeUnit unitSize) {
        if (unitSize != null) {
            return this.preparedRounding.roundingSize(unitSize);
        }
        return 1.0;
    }
}

