/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.aggregations.bucket;

import java.io.IOException;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.IntFunction;
import java.util.function.LongUnaryOperator;
import java.util.function.ToLongFunction;
import org.apache.lucene.index.LeafReaderContext;
import org.elasticsearch.common.util.IntArray;
import org.elasticsearch.common.util.LongArray;
import org.elasticsearch.common.util.ObjectArray;
import org.elasticsearch.search.aggregations.AggregationErrors;
import org.elasticsearch.search.aggregations.Aggregator;
import org.elasticsearch.search.aggregations.AggregatorBase;
import org.elasticsearch.search.aggregations.AggregatorFactories;
import org.elasticsearch.search.aggregations.CardinalityUpperBound;
import org.elasticsearch.search.aggregations.InternalAggregation;
import org.elasticsearch.search.aggregations.InternalAggregations;
import org.elasticsearch.search.aggregations.LeafBucketCollector;
import org.elasticsearch.search.aggregations.bucket.DocCountProvider;
import org.elasticsearch.search.aggregations.bucket.SingleBucketAggregator;
import org.elasticsearch.search.aggregations.bucket.global.GlobalAggregator;
import org.elasticsearch.search.aggregations.bucket.terms.LongKeyedBucketOrds;
import org.elasticsearch.search.aggregations.support.AggregationContext;
import org.elasticsearch.search.aggregations.support.AggregationPath;
import org.elasticsearch.search.sort.SortOrder;
import org.elasticsearch.tasks.TaskCancelledException;

public abstract class BucketsAggregator
extends AggregatorBase {
    private LongArray docCounts = this.bigArrays().newLongArray(1L, true);
    protected final DocCountProvider docCountProvider = new DocCountProvider();

    public BucketsAggregator(String name, AggregatorFactories factories, AggregationContext aggCtx, Aggregator parent, CardinalityUpperBound bucketCardinality, Map<String, Object> metadata) throws IOException {
        super(name, factories, aggCtx, parent, bucketCardinality, metadata);
    }

    public final void grow(long maxBucketOrd) {
        this.docCounts = this.bigArrays().grow(this.docCounts, maxBucketOrd);
    }

    public final void collectBucket(LeafBucketCollector subCollector, int doc, long bucketOrd) throws IOException {
        this.grow(bucketOrd + 1L);
        int docCount = this.docCountProvider.getDocCount(doc);
        if (this.docCounts.increment(bucketOrd, docCount) == (long)docCount) {
            this.checkRealMemoryCB("allocated_buckets");
        }
        subCollector.collect(doc, bucketOrd);
    }

    public final void collectExistingBucket(LeafBucketCollector subCollector, int doc, long bucketOrd) throws IOException {
        this.docCounts.increment(bucketOrd, this.docCountProvider.getDocCount(doc));
        subCollector.collect(doc, bucketOrd);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void rewriteBuckets(long newNumBuckets, LongUnaryOperator mergeMap) {
        LongArray oldDocCounts = this.docCounts;
        boolean success = false;
        try {
            this.docCounts = this.bigArrays().newLongArray(newNumBuckets, true);
            success = true;
            for (long i = 0L; i < oldDocCounts.size(); ++i) {
                long destinationOrdinal;
                long docCount = oldDocCounts.get(i);
                if (docCount == 0L || (destinationOrdinal = mergeMap.applyAsLong(i)) == -1L) continue;
                this.docCounts.increment(destinationOrdinal, docCount);
            }
        }
        finally {
            if (success) {
                oldDocCounts.close();
            }
        }
    }

    public LongArray getDocCounts() {
        return this.docCounts;
    }

    public final void incrementBucketDocCount(long bucketOrd, long inc) {
        this.docCounts = this.bigArrays().grow(this.docCounts, bucketOrd + 1L);
        this.docCounts.increment(bucketOrd, inc);
    }

    public final long bucketDocCount(long bucketOrd) {
        if (bucketOrd >= this.docCounts.size()) {
            return 0L;
        }
        return this.docCounts.get(bucketOrd);
    }

    protected void prepareSubAggs(LongArray ordsToCollect) throws IOException {
    }

    protected final IntFunction<InternalAggregations> buildSubAggsForBuckets(LongArray bucketOrdsToCollect) throws IOException {
        if (this.context.isCancelled()) {
            throw new TaskCancelledException("not building sub-aggregations due to task cancellation");
        }
        this.prepareSubAggs(bucketOrdsToCollect);
        InternalAggregation[][] aggregations = new InternalAggregation[this.subAggregators.length][];
        for (int i = 0; i < this.subAggregators.length; ++i) {
            this.checkRealMemoryCB("building_sub_aggregation");
            aggregations[i] = this.subAggregators[i].buildAggregations(bucketOrdsToCollect);
        }
        return BucketsAggregator.subAggsForBucketFunction(aggregations);
    }

    private static IntFunction<InternalAggregations> subAggsForBucketFunction(final InternalAggregation[][] aggregations) {
        return ord -> InternalAggregations.from((List<InternalAggregation>)new AbstractList<InternalAggregation>(){

            @Override
            public InternalAggregation get(int index) {
                return aggregations[index][ord];
            }

            @Override
            public int size() {
                return aggregations.length;
            }
        });
    }

    protected final <B> void buildSubAggsForAllBuckets(ObjectArray<B[]> buckets, ToLongFunction<B> bucketToOrd, BiConsumer<B, InternalAggregations> setAggs) throws IOException {
        long totalBucketOrdsToCollect = 0L;
        for (long b = 0L; b < buckets.size(); ++b) {
            totalBucketOrdsToCollect += (long)buckets.get(b).length;
        }
        try (LongArray bucketOrdsToCollect = this.bigArrays().newLongArray(totalBucketOrdsToCollect);){
            int s = 0;
            for (long ord = 0L; ord < buckets.size(); ++ord) {
                for (B bucket : buckets.get(ord)) {
                    bucketOrdsToCollect.set(s++, bucketToOrd.applyAsLong(bucket));
                }
            }
            this.buildSubAggsForAllBuckets(buckets, bucketOrdsToCollect, setAggs);
        }
    }

    protected final <B> void buildSubAggsForAllBuckets(ObjectArray<B[]> buckets, LongArray bucketOrdsToCollect, BiConsumer<B, InternalAggregations> setAggs) throws IOException {
        IntFunction<InternalAggregations> results = this.buildSubAggsForBuckets(bucketOrdsToCollect);
        int s = 0;
        for (long ord = 0L; ord < buckets.size(); ++ord) {
            for (B value : buckets.get(ord)) {
                setAggs.accept(value, results.apply(s++));
            }
        }
    }

    protected final <B> InternalAggregation[] buildAggregationsForFixedBucketCount(LongArray owningBucketOrds, int bucketsPerOwningBucketOrd, BucketBuilderForFixedCount<B> bucketBuilder, Function<List<B>, InternalAggregation> resultBuilder) throws IOException {
        try (LongArray bucketOrdsToCollect = this.bigArrays().newLongArray(owningBucketOrds.size() * (long)bucketsPerOwningBucketOrd);){
            int[] bucketOrdIdx = new int[]{0};
            for (long i = 0L; i < owningBucketOrds.size(); ++i) {
                long ord = owningBucketOrds.get(i) * (long)bucketsPerOwningBucketOrd;
                for (int offsetInOwningOrd = 0; offsetInOwningOrd < bucketsPerOwningBucketOrd; ++offsetInOwningOrd) {
                    int n = bucketOrdIdx[0];
                    bucketOrdIdx[0] = n + 1;
                    bucketOrdsToCollect.set(n, ord++);
                }
            }
            bucketOrdIdx[0] = 0;
            IntFunction<InternalAggregations> subAggregationResults = this.buildSubAggsForBuckets(bucketOrdsToCollect);
            InternalAggregation[] internalAggregationArray = this.buildAggregations(Math.toIntExact(owningBucketOrds.size()), ordIdx -> {
                ArrayList buckets = new ArrayList(bucketsPerOwningBucketOrd);
                for (int offsetInOwningOrd = 0; offsetInOwningOrd < bucketsPerOwningBucketOrd; ++offsetInOwningOrd) {
                    this.checkRealMemoryCBForInternalBucket();
                    int n = bucketOrdIdx[0];
                    bucketOrdIdx[0] = n + 1;
                    buckets.add(bucketBuilder.build(offsetInOwningOrd, this.bucketDocCount(bucketOrdsToCollect.get(bucketOrdIdx[0])), (InternalAggregations)subAggregationResults.apply(n)));
                }
                return (InternalAggregation)resultBuilder.apply(buckets);
            });
            return internalAggregationArray;
        }
    }

    protected final InternalAggregation[] buildAggregationsForSingleBucket(LongArray owningBucketOrds, SingleBucketResultBuilder resultBuilder) throws IOException {
        IntFunction<InternalAggregations> subAggregationResults = this.buildSubAggsForBuckets(owningBucketOrds);
        return this.buildAggregations(Math.toIntExact(owningBucketOrds.size()), ordIdx -> resultBuilder.build(owningBucketOrds.get(ordIdx), (InternalAggregations)subAggregationResults.apply(ordIdx)));
    }

    protected final <B> InternalAggregation[] buildAggregationsForVariableBuckets(LongArray owningBucketOrds, LongKeyedBucketOrds bucketOrds, BucketBuilderForVariable<B> bucketBuilder, ResultBuilderForVariable<B> resultBuilder) throws IOException {
        long totalOrdsToCollect = 0L;
        try (IntArray bucketsInOrd = this.bigArrays().newIntArray(owningBucketOrds.size());){
            InternalAggregation[] internalAggregationArray;
            block16: {
                for (long ordIdx2 = 0L; ordIdx2 < owningBucketOrds.size(); ++ordIdx2) {
                    long bucketCount = bucketOrds.bucketsInOrd(owningBucketOrds.get(ordIdx2));
                    bucketsInOrd.set(ordIdx2, (int)bucketCount);
                    totalOrdsToCollect += bucketCount;
                }
                if (totalOrdsToCollect > Integer.MAX_VALUE) {
                    throw new IllegalArgumentException("Can't collect more than [2147483647] buckets but attempted [" + totalOrdsToCollect + "]");
                }
                LongArray bucketOrdsToCollect = this.bigArrays().newLongArray(totalOrdsToCollect);
                try {
                    int[] b = new int[]{0};
                    for (long i = 0L; i < owningBucketOrds.size(); ++i) {
                        LongKeyedBucketOrds.BucketOrdsEnum ordsEnum = bucketOrds.ordsEnum(owningBucketOrds.get(i));
                        while (ordsEnum.next()) {
                            int n = b[0];
                            b[0] = n + 1;
                            bucketOrdsToCollect.set(n, ordsEnum.ord());
                        }
                    }
                    IntFunction<InternalAggregations> subAggregationResults = this.buildSubAggsForBuckets(bucketOrdsToCollect);
                    b[0] = 0;
                    internalAggregationArray = this.buildAggregations(Math.toIntExact(owningBucketOrds.size()), ordIdx -> {
                        long owningBucketOrd = owningBucketOrds.get(ordIdx);
                        ArrayList buckets = new ArrayList(bucketsInOrd.get(ordIdx));
                        LongKeyedBucketOrds.BucketOrdsEnum ordsEnum = bucketOrds.ordsEnum(owningBucketOrd);
                        while (ordsEnum.next()) {
                            if (bucketOrdsToCollect.get(b[0]) != ordsEnum.ord()) {
                                throw AggregationErrors.iterationOrderChangedWithoutMutating(bucketOrds.toString(), ordsEnum.ord(), bucketOrdsToCollect.get(b[0]));
                            }
                            this.checkRealMemoryCBForInternalBucket();
                            int n = b[0];
                            b[0] = n + 1;
                            buckets.add(bucketBuilder.build(ordsEnum.value(), this.bucketDocCount(ordsEnum.ord()), (InternalAggregations)subAggregationResults.apply(n)));
                        }
                        return resultBuilder.build(owningBucketOrd, buckets);
                    });
                    if (bucketOrdsToCollect == null) break block16;
                }
                catch (Throwable throwable) {
                    if (bucketOrdsToCollect != null) {
                        try {
                            bucketOrdsToCollect.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                bucketOrdsToCollect.close();
            }
            return internalAggregationArray;
        }
    }

    @Override
    public final void close() {
        try (LongArray releasable = this.docCounts;){
            super.close();
        }
    }

    @Override
    public Aggregator resolveSortPath(AggregationPath.PathElement next, Iterator<AggregationPath.PathElement> path) {
        if (this instanceof SingleBucketAggregator) {
            return this.resolveSortPathOnValidAgg(next, path);
        }
        return super.resolveSortPath(next, path);
    }

    @Override
    public Aggregator.BucketComparator bucketComparator(String key, SortOrder order) {
        if (!(this instanceof SingleBucketAggregator)) {
            return super.bucketComparator(key, order);
        }
        if (key == null || "doc_count".equals(key)) {
            return (lhs, rhs) -> order.reverseMul() * Long.compare(this.bucketDocCount(lhs), this.bucketDocCount(rhs));
        }
        throw new IllegalArgumentException(String.format(Locale.ROOT, "Ordering on a single-bucket aggregation can only be done on its doc_count. Either drop the key (a la \"%s\") or change it to \"doc_count\" (a la \"%s.doc_count\") or \"key\".", this.name(), this.name()));
    }

    public static boolean descendsFromGlobalAggregator(Aggregator parent) {
        while (parent != null) {
            if (parent.getClass() == GlobalAggregator.class) {
                return true;
            }
            parent = parent.parent();
        }
        return false;
    }

    @Override
    protected void preGetSubLeafCollectors(LeafReaderContext ctx) throws IOException {
        super.preGetSubLeafCollectors(ctx);
        this.docCountProvider.setLeafReaderContext(ctx);
    }

    protected final void checkRealMemoryCBForInternalBucket() {
        this.checkRealMemoryCB("internal_bucket");
    }

    @FunctionalInterface
    protected static interface BucketBuilderForFixedCount<B> {
        public B build(int var1, long var2, InternalAggregations var4);
    }

    @FunctionalInterface
    protected static interface SingleBucketResultBuilder {
        public InternalAggregation build(long var1, InternalAggregations var3);
    }

    @FunctionalInterface
    protected static interface BucketBuilderForVariable<B> {
        public B build(long var1, long var3, InternalAggregations var5);
    }

    @FunctionalInterface
    protected static interface ResultBuilderForVariable<B> {
        public InternalAggregation build(long var1, List<B> var3);
    }
}

