/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.script.field;

import java.io.IOException;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import org.elasticsearch.TransportVersion;
import org.elasticsearch.TransportVersions;
import org.elasticsearch.common.io.stream.GenericNamedWriteable;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.network.InetAddresses;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentObject;
import org.elasticsearch.xcontent.XContentBuilder;

public class IPAddress
implements ToXContentObject,
GenericNamedWriteable {
    static final String NAMED_WRITEABLE_NAME = "IPAddress";
    protected final InetAddress address;

    IPAddress(InetAddress address) {
        this.address = address;
    }

    public IPAddress(String address) {
        this.address = InetAddresses.forString(address);
    }

    public IPAddress(StreamInput input) throws IOException {
        this(input.readString());
    }

    @Override
    public void writeTo(StreamOutput output) throws IOException {
        output.writeString(this.toString());
    }

    public boolean isV4() {
        return this.address instanceof Inet4Address;
    }

    public boolean isV6() {
        return this.address instanceof Inet6Address;
    }

    public String toString() {
        return InetAddresses.toAddrString(this.address);
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        return builder.value(this.toString());
    }

    @Override
    public String getWriteableName() {
        return NAMED_WRITEABLE_NAME;
    }

    @Override
    public TransportVersion getMinimalSupportedVersion() {
        return TransportVersions.V_8_12_0;
    }
}

