/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.script.field;

import org.elasticsearch.common.geo.BoundingBox;
import org.elasticsearch.common.geo.GeoBoundingBox;
import org.elasticsearch.common.geo.GeoPoint;
import org.elasticsearch.common.geo.GeoUtils;
import org.elasticsearch.common.geo.SpatialPoint;
import org.elasticsearch.index.fielddata.MultiGeoPointValues;
import org.elasticsearch.index.fielddata.MultiPointValues;
import org.elasticsearch.index.fielddata.ScriptDocValues;
import org.elasticsearch.script.field.PointDocValuesField;

public class GeoPointDocValuesField
extends PointDocValuesField<GeoPoint> {
    private ScriptDocValues.GeoPoints geoPoints = null;

    public GeoPointDocValuesField(MultiGeoPointValues input, String name) {
        super((MultiPointValues)input, name, GeoPoint::new, (BoundingBox)new GeoBoundingBox(new GeoPoint(), new GeoPoint()), (SpatialPoint[])new GeoPoint[0]);
    }

    @Override
    protected void resetPointAt(int i, GeoPoint point) {
        ((GeoPoint[])this.values)[i].reset(point.lat(), point.lon());
    }

    @Override
    protected void resetCentroidAndBounds(GeoPoint point, GeoPoint topLeft, GeoPoint bottomRight) {
        ((GeoPoint)this.centroid).reset(point.lat() / (double)this.count, point.lon() / (double)this.count);
        ((GeoPoint)this.boundingBox.topLeft()).reset(topLeft.lat(), topLeft.lon());
        ((GeoPoint)this.boundingBox.bottomRight()).reset(bottomRight.lat(), bottomRight.lon());
    }

    @Override
    protected double getXFrom(GeoPoint point) {
        return point.lon();
    }

    @Override
    protected double getYFrom(GeoPoint point) {
        return point.lat();
    }

    @Override
    protected GeoPoint pointOf(double x, double y) {
        return new GeoPoint(y, x);
    }

    @Override
    protected double planeDistance(double x1, double y1, GeoPoint point) {
        return GeoUtils.planeDistance(y1, x1, point.lat(), point.lon());
    }

    @Override
    public GeoPoint get(GeoPoint defaultValue) {
        return super.get(defaultValue);
    }

    @Override
    public GeoPoint get(int index, GeoPoint defaultValue) {
        return super.get(index, defaultValue);
    }

    public ScriptDocValues<GeoPoint> toScriptDocValues() {
        if (this.geoPoints == null) {
            this.geoPoints = new ScriptDocValues.GeoPoints(this);
        }
        return this.geoPoints;
    }
}

