/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.script;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Supplier;
import org.apache.lucene.index.LeafReaderContext;
import org.elasticsearch.common.logging.DeprecationCategory;
import org.elasticsearch.common.logging.DeprecationLogger;
import org.elasticsearch.script.DocBasedScript;
import org.elasticsearch.script.DocReader;
import org.elasticsearch.script.DocValuesDocReader;
import org.elasticsearch.script.DynamicMap;
import org.elasticsearch.script.ScriptContext;
import org.elasticsearch.script.ScriptFactory;
import org.elasticsearch.search.lookup.SearchLookup;
import org.elasticsearch.search.lookup.Source;

public abstract class FieldScript
extends DocBasedScript {
    public static final String[] PARAMETERS = new String[0];
    private static final DeprecationLogger deprecationLogger = DeprecationLogger.getLogger(DynamicMap.class);
    private static final Map<String, Function<Object, Object>> PARAMS_FUNCTIONS = Map.of("doc", value -> {
        deprecationLogger.warn(DeprecationCategory.SCRIPTING, "field-script_doc", "Accessing variable [doc] via [params.doc] from within an field-script is deprecated in favor of directly accessing [doc].", new Object[0]);
        return value;
    }, "_doc", value -> {
        deprecationLogger.warn(DeprecationCategory.SCRIPTING, "field-script__doc", "Accessing variable [doc] via [params._doc] from within an field-script is deprecated in favor of directly accessing [doc].", new Object[0]);
        return value;
    }, "_source", value -> ((Source)((Supplier)value).get()).source());
    private final Map<String, Object> params;
    public static final ScriptContext<Factory> CONTEXT = new ScriptContext<Factory>("field", Factory.class);

    public FieldScript(Map<String, Object> params, SearchLookup lookup, LeafReaderContext leafContext) {
        this(params, new DocValuesDocReader(lookup, leafContext));
    }

    private FieldScript(Map<String, Object> params, DocReader docReader) {
        super(docReader);
        params = new HashMap<String, Object>(params);
        params.putAll(docReader.docAsMap());
        this.params = new DynamicMap(params, PARAMS_FUNCTIONS);
    }

    protected FieldScript() {
        super(null);
        this.params = null;
    }

    public abstract Object execute();

    public Map<String, Object> getParams() {
        return this.params;
    }

    public static interface Factory
    extends ScriptFactory {
        public LeafFactory newFactory(Map<String, Object> var1, SearchLookup var2);
    }

    public static interface LeafFactory {
        public FieldScript newInstance(LeafReaderContext var1) throws IOException;
    }
}

