/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.rest.action;

import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicReference;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.admin.cluster.node.tasks.cancel.CancelTasksRequest;
import org.elasticsearch.client.internal.FilterClient;
import org.elasticsearch.client.internal.OriginSettingClient;
import org.elasticsearch.client.internal.node.NodeClient;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.http.HttpChannel;
import org.elasticsearch.tasks.CancellableTask;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.tasks.TaskId;

public class RestCancellableNodeClient
extends FilterClient {
    private static final Map<HttpChannel, CloseListener> httpChannels = new ConcurrentHashMap<HttpChannel, CloseListener>();
    private final NodeClient client;
    private final HttpChannel httpChannel;

    public RestCancellableNodeClient(NodeClient client, HttpChannel httpChannel) {
        super(client);
        this.client = client;
        this.httpChannel = httpChannel;
    }

    public static int getNumChannels() {
        return httpChannels.size();
    }

    static int getNumTasks() {
        return httpChannels.values().stream().mapToInt(CloseListener::getNumTasks).sum();
    }

    static int getNumTasks(HttpChannel channel) {
        CloseListener listener = httpChannels.get(channel);
        return listener == null ? 0 : listener.getNumTasks();
    }

    @Override
    public <Request extends ActionRequest, Response extends ActionResponse> void doExecute(ActionType<Response> action, Request request, final ActionListener<Response> listener) {
        final CloseListener closeListener = httpChannels.computeIfAbsent(this.httpChannel, channel -> new CloseListener());
        final TaskHolder taskHolder = new TaskHolder();
        Task task = this.client.executeLocally(action, request, new ActionListener<Response>(this){

            @Override
            public void onResponse(Response response) {
                try {
                    closeListener.unregisterTask(taskHolder);
                }
                finally {
                    listener.onResponse(response);
                }
            }

            @Override
            public void onFailure(Exception e) {
                try {
                    closeListener.unregisterTask(taskHolder);
                }
                finally {
                    listener.onFailure(e);
                }
            }
        });
        assert (task instanceof CancellableTask) : action.name() + " is not cancellable";
        TaskId taskId = new TaskId(this.client.getLocalNodeId(), task.getId());
        closeListener.registerTask(taskHolder, taskId);
        closeListener.maybeRegisterChannel(this.httpChannel);
    }

    private void cancelTask(TaskId taskId) {
        CancelTasksRequest req = ((CancelTasksRequest)new CancelTasksRequest().setTargetTaskId(taskId)).setReason("http channel [" + String.valueOf(this.httpChannel) + "] closed");
        new OriginSettingClient(this.client, "tasks").admin().cluster().cancelTasks(req, ActionListener.noop());
    }

    private class CloseListener
    implements ActionListener<Void> {
        private final AtomicReference<HttpChannel> channel = new AtomicReference();
        @Nullable
        private Set<TaskId> tasks = new HashSet<TaskId>();

        CloseListener() {
        }

        synchronized int getNumTasks() {
            return this.tasks == null ? 0 : this.tasks.size();
        }

        void maybeRegisterChannel(HttpChannel httpChannel) {
            if (this.channel.compareAndSet(null, httpChannel)) {
                httpChannel.addCloseListener(this);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void registerTask(TaskHolder taskHolder, TaskId taskId) {
            CloseListener closeListener = this;
            synchronized (closeListener) {
                taskHolder.taskId = taskId;
                if (this.tasks != null) {
                    if (!taskHolder.completed) {
                        this.tasks.add(taskId);
                    }
                    return;
                }
            }
            RestCancellableNodeClient.this.cancelTask(taskId);
        }

        synchronized void unregisterTask(TaskHolder taskHolder) {
            if (taskHolder.taskId != null && this.tasks != null) {
                this.tasks.remove(taskHolder.taskId);
            }
            taskHolder.completed = true;
        }

        @Override
        public void onResponse(Void aVoid) {
            HttpChannel httpChannel = this.channel.get();
            assert (httpChannel != null) : "channel not registered";
            CloseListener closeListener = httpChannels.remove(httpChannel);
            assert (closeListener != null) : "channel not found in the map of tracked channels: " + String.valueOf(httpChannel);
            assert (closeListener == this) : "channel had a different CloseListener registered: " + String.valueOf(httpChannel);
            for (TaskId taskId : this.drainTasks()) {
                RestCancellableNodeClient.this.cancelTask(taskId);
            }
        }

        private synchronized Collection<TaskId> drainTasks() {
            Set<TaskId> drained = this.tasks;
            this.tasks = null;
            return drained;
        }

        @Override
        public void onFailure(Exception e) {
            this.onResponse(null);
        }
    }

    private static class TaskHolder {
        private TaskId taskId;
        private boolean completed = false;

        private TaskHolder() {
        }
    }
}

