/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.reservedstate.service;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileTime;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.stream.Stream;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.action.support.PlainActionFuture;
import org.elasticsearch.action.support.master.AcknowledgedResponse;
import org.elasticsearch.client.internal.Client;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.ClusterStateListener;
import org.elasticsearch.cluster.NotMasterException;
import org.elasticsearch.cluster.coordination.FailedToCommitClusterStateException;
import org.elasticsearch.cluster.metadata.Metadata;
import org.elasticsearch.cluster.metadata.ReservedStateMetadata;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.file.MasterNodeFileWatchingService;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.env.Environment;
import org.elasticsearch.health.HealthIndicatorDetails;
import org.elasticsearch.health.HealthIndicatorImpact;
import org.elasticsearch.health.HealthIndicatorResult;
import org.elasticsearch.health.HealthIndicatorService;
import org.elasticsearch.health.HealthStatus;
import org.elasticsearch.health.ImpactArea;
import org.elasticsearch.health.SimpleHealthIndicatorDetails;
import org.elasticsearch.health.node.HealthInfo;
import org.elasticsearch.health.node.UpdateHealthInfoCacheAction;
import org.elasticsearch.health.node.selection.HealthNode;
import org.elasticsearch.reservedstate.service.FileSettingsHealthIndicatorPublisher;
import org.elasticsearch.reservedstate.service.ReservedClusterStateService;
import org.elasticsearch.reservedstate.service.ReservedStateVersionCheck;
import org.elasticsearch.xcontent.XContentParseException;
import org.elasticsearch.xcontent.XContentParser;
import org.elasticsearch.xcontent.XContentParserConfiguration;
import org.elasticsearch.xcontent.XContentType;

public class FileSettingsService
extends MasterNodeFileWatchingService
implements ClusterStateListener {
    private static final Logger logger = LogManager.getLogger(FileSettingsService.class);
    public static final String SETTINGS_FILE_NAME = "settings.json";
    public static final String NAMESPACE = "file_settings";
    public static final String OPERATOR_DIRECTORY = "operator";
    private final Path watchedFile = this.watchedFileDir().resolve("settings.json");
    private final ReservedClusterStateService stateService;
    private final FileSettingsHealthTracker healthIndicatorTracker;

    public FileSettingsService(ClusterService clusterService, ReservedClusterStateService stateService, Environment environment, FileSettingsHealthTracker healthIndicatorTracker) {
        super(clusterService, environment.configDir().toAbsolutePath().resolve(OPERATOR_DIRECTORY));
        this.stateService = stateService;
        this.healthIndicatorTracker = healthIndicatorTracker;
    }

    protected Logger logger() {
        return logger;
    }

    public Path watchedFile() {
        return this.watchedFile;
    }

    public void handleSnapshotRestore(ClusterState clusterState, Metadata.Builder mdBuilder) {
        assert (clusterState.nodes().isLocalNodeElectedMaster());
        ReservedStateMetadata fileSettingsMetadata = clusterState.metadata().reservedStateMetadata().get(NAMESPACE);
        if (this.watching() && this.filesExists(this.watchedFile)) {
            if (fileSettingsMetadata != null) {
                ReservedStateMetadata withResetVersion = new ReservedStateMetadata.Builder(fileSettingsMetadata).version(0L).build();
                mdBuilder.put(withResetVersion);
            }
        } else if (fileSettingsMetadata != null) {
            mdBuilder.removeReservedState(fileSettingsMetadata);
        }
    }

    @Override
    protected void doStart() {
        this.healthIndicatorTracker.startOccurred();
        super.doStart();
    }

    @Override
    protected void doStop() {
        super.doStop();
        this.healthIndicatorTracker.stopOccurred();
    }

    @Override
    protected boolean shouldRefreshFileState(ClusterState clusterState) {
        ReservedStateMetadata fileSettingsMetadata = clusterState.metadata().reservedStateMetadata().get(NAMESPACE);
        return fileSettingsMetadata != null && fileSettingsMetadata.version().equals(ReservedStateMetadata.RESTORED_VERSION);
    }

    @Override
    protected final void processFileChanges(Path file) throws ExecutionException, InterruptedException, IOException {
        this.processFile(file, false);
    }

    @Override
    protected final void processFileOnServiceStart(Path file) throws IOException, ExecutionException, InterruptedException {
        this.processFile(file, true);
    }

    protected void processFile(Path file, boolean startup) throws IOException, ExecutionException, InterruptedException {
        if (!this.watchedFile.equals(file)) {
            this.logger().debug("Received notification for unknown file {}", (Object)file);
        } else {
            this.logger().info("processing path [{}] for [{}]{}", (Object)this.watchedFile, (Object)NAMESPACE, (Object)(startup ? " on service start" : ""));
            this.healthIndicatorTracker.changeOccurred();
            this.processFileChanges(startup ? ReservedStateVersionCheck.HIGHER_OR_SAME_VERSION : ReservedStateVersionCheck.HIGHER_VERSION_ONLY);
        }
    }

    protected XContentParser createParser(InputStream stream) throws IOException {
        return XContentType.JSON.xContent().createParser(XContentParserConfiguration.EMPTY, stream);
    }

    private void processFileChanges(ReservedStateVersionCheck versionCheck) throws IOException, InterruptedException, ExecutionException {
        PlainActionFuture completion = new PlainActionFuture();
        try (BufferedInputStream bis = new BufferedInputStream(this.filesNewInputStream(this.watchedFile));
             XContentParser parser = this.createParser(bis);){
            this.stateService.process(NAMESPACE, parser, versionCheck, e -> this.completeProcessing((Exception)e, completion));
        }
        completion.get();
    }

    protected void completeProcessing(Exception e, PlainActionFuture<Void> completion) {
        try {
            if (e != null) {
                this.healthIndicatorTracker.failureOccurred(e.toString());
                completion.onFailure(e);
            } else {
                completion.onResponse(null);
                this.healthIndicatorTracker.successOccurred();
            }
        }
        finally {
            this.logger().debug("Publishing to health node");
            this.healthIndicatorTracker.publish();
        }
    }

    @Override
    protected void onProcessFileChangesException(Path file, Exception e) {
        if (e instanceof ExecutionException) {
            Throwable cause = e.getCause();
            if (cause instanceof FailedToCommitClusterStateException) {
                this.logger().error(Strings.format("Unable to commit cluster state while processing file [%s]", file), (Throwable)e);
                return;
            }
            if (cause instanceof XContentParseException) {
                this.logger().error(Strings.format("Unable to parse settings from file [%s]", file), (Throwable)e);
                return;
            }
            if (cause instanceof NotMasterException) {
                this.logger().error(Strings.format("Node is no longer master while processing file [%s]", file), (Throwable)e);
                return;
            }
        }
        super.onProcessFileChangesException(file, e);
    }

    @Override
    protected void processInitialFilesMissing() throws ExecutionException, InterruptedException {
        PlainActionFuture<ActionResponse.Empty> completion = new PlainActionFuture<ActionResponse.Empty>();
        this.logger().info("setting file [{}] not found, initializing [{}] as empty", (Object)this.watchedFile, (Object)NAMESPACE);
        this.stateService.initEmpty(NAMESPACE, completion);
        completion.get();
    }

    @Override
    protected boolean filesExists(Path path) {
        return Files.exists(path, new LinkOption[0]);
    }

    @Override
    protected boolean filesIsDirectory(Path path) {
        return Files.isDirectory(path, new LinkOption[0]);
    }

    @Override
    protected boolean filesIsSymbolicLink(Path path) {
        return Files.isSymbolicLink(path);
    }

    @Override
    protected <A extends BasicFileAttributes> A filesReadAttributes(Path path, Class<A> clazz) throws IOException {
        return Files.readAttributes(path, clazz, new LinkOption[0]);
    }

    @Override
    protected Stream<Path> filesList(Path dir) throws IOException {
        return Files.list(dir);
    }

    @Override
    protected Path filesSetLastModifiedTime(Path path, FileTime time) throws IOException {
        return Files.setLastModifiedTime(path, time);
    }

    @Override
    protected InputStream filesNewInputStream(Path path) throws IOException {
        return Files.newInputStream(path, new OpenOption[0]);
    }

    public static class FileSettingsHealthTracker {
        public static final String DESCRIPTION_LENGTH_LIMIT_KEY = "fileSettings.descriptionLengthLimit";
        static final Setting<Integer> DESCRIPTION_LENGTH_LIMIT = Setting.intSetting("fileSettings.descriptionLengthLimit", 100, 1, Setting.Property.OperatorDynamic);
        private final Settings settings;
        private final FileSettingsHealthIndicatorPublisher publisher;
        private FileSettingsHealthInfo currentInfo = FileSettingsHealthInfo.INDETERMINATE;

        public FileSettingsHealthTracker(Settings settings, FileSettingsHealthIndicatorPublisher publisher) {
            this.settings = settings;
            this.publisher = publisher;
        }

        public FileSettingsHealthInfo getCurrentInfo() {
            return this.currentInfo;
        }

        public synchronized void startOccurred() {
            this.currentInfo = FileSettingsHealthInfo.INITIAL_ACTIVE;
        }

        public synchronized void stopOccurred() {
            this.currentInfo = this.currentInfo.inactive();
        }

        public synchronized void changeOccurred() {
            this.currentInfo = this.currentInfo.changed();
        }

        public synchronized void successOccurred() {
            this.currentInfo = this.currentInfo.successful();
        }

        public synchronized void failureOccurred(String description) {
            this.currentInfo = this.currentInfo.failed(this.limitLength(description));
        }

        private String limitLength(String description) {
            int descriptionLengthLimit = DESCRIPTION_LENGTH_LIMIT.get(this.settings);
            if (description.length() > descriptionLengthLimit) {
                return description.substring(0, descriptionLengthLimit - 1) + "\u2026";
            }
            return description;
        }

        public void publish() {
            this.publisher.publish(this.currentInfo, ActionListener.wrap(r -> logger.debug("Successfully published health indicator"), e -> logger.warn("Failed to publish health indicator", (Throwable)e)));
        }
    }

    public static class FileSettingsHealthIndicatorPublisherImpl
    implements FileSettingsHealthIndicatorPublisher {
        private final ClusterService clusterService;
        private final Client client;

        public FileSettingsHealthIndicatorPublisherImpl(ClusterService clusterService, Client client) {
            this.clusterService = clusterService;
            this.client = client;
        }

        @Override
        public void publish(FileSettingsHealthInfo info, ActionListener<AcknowledgedResponse> actionListener) {
            DiscoveryNode currentHealthNode = HealthNode.findHealthNode(this.clusterService.state());
            if (currentHealthNode == null) {
                logger.debug("Unable to report file settings health because there is no health node in the cluster; will retry next time file settings health changes.");
            } else {
                logger.debug("Publishing file settings health indicators: [{}]", (Object)info);
                String localNode = this.clusterService.localNode().getId();
                this.client.execute(UpdateHealthInfoCacheAction.INSTANCE, new UpdateHealthInfoCacheAction.Request(localNode, info), actionListener);
            }
        }
    }

    public static class FileSettingsHealthIndicatorService
    implements HealthIndicatorService {
        static final String NAME = "file_settings";
        static final String INACTIVE_SYMPTOM = "File-based settings are inactive";
        static final String NO_CHANGES_SYMPTOM = "No file-based setting changes have occurred";
        static final String SUCCESS_SYMPTOM = "The most recent file-based settings were applied successfully";
        static final String FAILURE_SYMPTOM = "The most recent file-based settings encountered an error";
        static final List<HealthIndicatorImpact> STALE_SETTINGS_IMPACT = List.of(new HealthIndicatorImpact("file_settings", "stale", 3, "The most recent file-based settings changes have not been applied.", List.of(ImpactArea.DEPLOYMENT_MANAGEMENT)));

        @Override
        public String name() {
            return "file_settings";
        }

        @Override
        public synchronized HealthIndicatorResult calculate(boolean verbose, int maxAffectedResourcesCount, HealthInfo healthInfo) {
            return this.calculate(healthInfo.fileSettingsHealthInfo());
        }

        public HealthIndicatorResult calculate(FileSettingsHealthInfo info) {
            if (!info.isActive()) {
                return this.createIndicator(HealthStatus.GREEN, INACTIVE_SYMPTOM, HealthIndicatorDetails.EMPTY, List.of(), List.of());
            }
            if (0L == info.changeCount()) {
                return this.createIndicator(HealthStatus.GREEN, NO_CHANGES_SYMPTOM, HealthIndicatorDetails.EMPTY, List.of(), List.of());
            }
            if (0L == info.failureStreak()) {
                return this.createIndicator(HealthStatus.GREEN, SUCCESS_SYMPTOM, HealthIndicatorDetails.EMPTY, List.of(), List.of());
            }
            return this.createIndicator(HealthStatus.YELLOW, FAILURE_SYMPTOM, new SimpleHealthIndicatorDetails(Map.of("failure_streak", info.failureStreak(), "most_recent_failure", info.mostRecentFailure())), STALE_SETTINGS_IMPACT, List.of());
        }
    }

    public record FileSettingsHealthInfo(boolean isActive, long changeCount, long failureStreak, String mostRecentFailure) implements Writeable
    {
        public static final FileSettingsHealthInfo INDETERMINATE = new FileSettingsHealthInfo(false, 0L, 0L, null);
        public static final FileSettingsHealthInfo INITIAL_ACTIVE = new FileSettingsHealthInfo(true, 0L, 0L, null);

        public FileSettingsHealthInfo(StreamInput in) throws IOException {
            this(in.readBoolean(), in.readVLong(), in.readVLong(), in.readOptionalString());
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            out.writeBoolean(this.isActive);
            out.writeVLong(this.changeCount);
            out.writeVLong(this.failureStreak);
            out.writeOptionalString(this.mostRecentFailure);
        }

        public FileSettingsHealthInfo inactive() {
            return new FileSettingsHealthInfo(false, this.changeCount, this.failureStreak, this.mostRecentFailure);
        }

        public FileSettingsHealthInfo changed() {
            return new FileSettingsHealthInfo(this.isActive, this.changeCount + 1L, this.failureStreak, this.mostRecentFailure);
        }

        public FileSettingsHealthInfo successful() {
            return new FileSettingsHealthInfo(this.isActive, this.changeCount, 0L, null);
        }

        public FileSettingsHealthInfo failed(String failureDescription) {
            return new FileSettingsHealthInfo(this.isActive, this.changeCount, this.failureStreak + 1L, failureDescription);
        }
    }
}

