/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.repositories;

import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import org.elasticsearch.cluster.metadata.ProjectMetadata;
import org.elasticsearch.cluster.metadata.RepositoriesMetadata;
import org.elasticsearch.cluster.metadata.RepositoryMetadata;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.regex.Regex;

public record ResolvedRepositories(List<RepositoryMetadata> repositoryMetadata, List<String> missing) {
    public static final String ALL_PATTERN = "_all";

    public static boolean isMatchAll(String[] patterns) {
        return patterns.length == 0 || patterns.length == 1 && (ALL_PATTERN.equalsIgnoreCase(patterns[0]) || Regex.isMatchAllPattern(patterns[0]));
    }

    public static ResolvedRepositories resolve(ProjectMetadata projectMetadata, String[] patterns) {
        RepositoriesMetadata repositories = RepositoriesMetadata.get(projectMetadata);
        if (ResolvedRepositories.isMatchAll(patterns)) {
            return new ResolvedRepositories(repositories.repositories(), List.of());
        }
        ArrayList<String> missingRepositories = new ArrayList<String>();
        ArrayList<String> includePatterns = new ArrayList<String>();
        ArrayList<String> excludePatterns = new ArrayList<String>();
        boolean seenWildcard = false;
        for (String pattern : patterns) {
            if (seenWildcard && pattern.length() > 1 && pattern.startsWith("-")) {
                excludePatterns.add(pattern.substring(1));
                continue;
            }
            if (Regex.isSimpleMatchPattern(pattern)) {
                seenWildcard = true;
            } else if (repositories.repository(pattern) == null) {
                missingRepositories.add(pattern);
            }
            includePatterns.add(pattern);
        }
        String[] excludes = excludePatterns.toArray(Strings.EMPTY_ARRAY);
        LinkedHashSet<RepositoryMetadata> repositoryListBuilder = new LinkedHashSet<RepositoryMetadata>();
        for (String repositoryOrPattern : includePatterns) {
            for (RepositoryMetadata repository : repositories.repositories()) {
                if (repositoryListBuilder.contains(repository) || !Regex.simpleMatch(repositoryOrPattern, repository.name()) || Regex.simpleMatch(excludes, repository.name())) continue;
                repositoryListBuilder.add(repository);
            }
        }
        return new ResolvedRepositories(List.copyOf(repositoryListBuilder), missingRepositories);
    }

    public boolean hasMissingRepositories() {
        return !this.missing.isEmpty();
    }
}

