/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.injection.guice;

import org.elasticsearch.injection.guice.BindingProcessor;
import org.elasticsearch.injection.guice.InjectorImpl;
import org.elasticsearch.injection.guice.Key;
import org.elasticsearch.injection.guice.Provider;
import org.elasticsearch.injection.guice.internal.Errors;
import org.elasticsearch.injection.guice.internal.ErrorsException;
import org.elasticsearch.injection.guice.internal.InternalContext;
import org.elasticsearch.injection.guice.internal.InternalFactory;
import org.elasticsearch.injection.guice.spi.Dependency;

class BoundProviderFactory<T>
implements InternalFactory<T>,
BindingProcessor.CreationListener {
    private final InjectorImpl injector;
    final Key<? extends Provider<? extends T>> providerKey;
    final Object source;
    private InternalFactory<? extends Provider<? extends T>> providerFactory;

    BoundProviderFactory(InjectorImpl injector, Key<? extends Provider<? extends T>> providerKey, Object source) {
        this.injector = injector;
        this.providerKey = providerKey;
        this.source = source;
    }

    @Override
    public void notify(Errors errors) {
        try {
            this.providerFactory = this.injector.getInternalFactory(this.providerKey, errors.withSource(this.source));
        }
        catch (ErrorsException e) {
            errors.merge(e.getErrors());
        }
    }

    @Override
    public T get(Errors errors, InternalContext context, Dependency<?> dependency) throws ErrorsException {
        errors = errors.withSource(this.providerKey);
        Provider<T> provider = this.providerFactory.get(errors, context, dependency);
        try {
            return errors.checkForNull(provider.get(), this.source, dependency);
        }
        catch (RuntimeException userException) {
            throw errors.errorInProvider(userException).toException();
        }
    }

    public String toString() {
        return this.providerKey.toString();
    }
}

