/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.indices.recovery.plan;

import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.lucene.util.Version;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.index.IndexVersion;
import org.elasticsearch.index.snapshots.blobstore.BlobStoreIndexShardSnapshot;
import org.elasticsearch.index.store.Store;
import org.elasticsearch.index.store.StoreFileMetadata;
import org.elasticsearch.repositories.IndexId;
import org.elasticsearch.repositories.ShardSnapshotInfo;

public class ShardSnapshot {
    private final ShardSnapshotInfo shardSnapshotInfo;
    private final Map<String, BlobStoreIndexShardSnapshot.FileInfo> snapshotFiles;
    private final Store.MetadataSnapshot metadataSnapshot;
    private final Version commitLuceneVersion;

    public ShardSnapshot(ShardSnapshotInfo shardSnapshotInfo, List<BlobStoreIndexShardSnapshot.FileInfo> snapshotFiles, Map<String, String> luceneCommitUserData, Version commitLuceneVersion) {
        this.shardSnapshotInfo = shardSnapshotInfo;
        this.snapshotFiles = snapshotFiles.stream().collect(Collectors.toMap(snapshotFile -> snapshotFile.metadata().name(), Function.identity()));
        this.metadataSnapshot = ShardSnapshot.convertToMetadataSnapshot(snapshotFiles, luceneCommitUserData);
        this.commitLuceneVersion = commitLuceneVersion;
    }

    public String getShardStateIdentifier() {
        return this.shardSnapshotInfo.getShardStateIdentifier();
    }

    public boolean isLogicallyEquivalent(@Nullable String shardStateIdentifier) {
        return shardStateIdentifier != null && shardStateIdentifier.equals(this.shardSnapshotInfo.getShardStateIdentifier());
    }

    public boolean hasDifferentPhysicalFiles(Store.MetadataSnapshot sourceSnapshot) {
        Store.RecoveryDiff recoveryDiff = this.metadataSnapshot.recoveryDiff(sourceSnapshot);
        return !recoveryDiff.different.isEmpty() || !recoveryDiff.missing.isEmpty();
    }

    public String getRepository() {
        return this.shardSnapshotInfo.getRepository();
    }

    public Store.MetadataSnapshot getMetadataSnapshot() {
        return this.metadataSnapshot;
    }

    public IndexId getIndexId() {
        return this.shardSnapshotInfo.getIndexId();
    }

    public ShardSnapshotInfo getShardSnapshotInfo() {
        return this.shardSnapshotInfo;
    }

    @Nullable
    public IndexVersion getCommitVersion() {
        return this.metadataSnapshot.getCommitVersion();
    }

    public Version getCommitLuceneVersion() {
        return this.commitLuceneVersion;
    }

    public List<BlobStoreIndexShardSnapshot.FileInfo> getSnapshotFilesMatching(List<StoreFileMetadata> segmentFiles) {
        return segmentFiles.stream().map(storeFileMetadata -> this.snapshotFiles.get(storeFileMetadata.name())).toList();
    }

    public List<BlobStoreIndexShardSnapshot.FileInfo> getSnapshotFiles() {
        return List.copyOf(this.snapshotFiles.values());
    }

    static Store.MetadataSnapshot convertToMetadataSnapshot(List<BlobStoreIndexShardSnapshot.FileInfo> snapshotFiles, Map<String, String> luceneCommitUserData) {
        return new Store.MetadataSnapshot(snapshotFiles.stream().map(BlobStoreIndexShardSnapshot.FileInfo::metadata).collect(Collectors.toMap(StoreFileMetadata::name, Function.identity())), luceneCommitUserData, 0L);
    }
}

