/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.indices.recovery;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.index.shard.ShardId;
import org.elasticsearch.indices.recovery.RecoveryTransportRequest;

public class RecoveryFilesInfoRequest
extends RecoveryTransportRequest {
    List<String> phase1FileNames;
    List<Long> phase1FileSizes;
    List<String> phase1ExistingFileNames;
    List<Long> phase1ExistingFileSizes;
    int totalTranslogOps;

    public RecoveryFilesInfoRequest(StreamInput in) throws IOException {
        super(in);
        int i;
        int size = in.readVInt();
        this.phase1FileNames = new ArrayList<String>(size);
        for (i = 0; i < size; ++i) {
            this.phase1FileNames.add(in.readString());
        }
        size = in.readVInt();
        this.phase1FileSizes = new ArrayList<Long>(size);
        for (i = 0; i < size; ++i) {
            this.phase1FileSizes.add(in.readVLong());
        }
        size = in.readVInt();
        this.phase1ExistingFileNames = new ArrayList<String>(size);
        for (i = 0; i < size; ++i) {
            this.phase1ExistingFileNames.add(in.readString());
        }
        size = in.readVInt();
        this.phase1ExistingFileSizes = new ArrayList<Long>(size);
        for (i = 0; i < size; ++i) {
            this.phase1ExistingFileSizes.add(in.readVLong());
        }
        this.totalTranslogOps = in.readVInt();
    }

    RecoveryFilesInfoRequest(long recoveryId, long requestSeqNo, ShardId shardId, List<String> phase1FileNames, List<Long> phase1FileSizes, List<String> phase1ExistingFileNames, List<Long> phase1ExistingFileSizes, int totalTranslogOps) {
        super(requestSeqNo, recoveryId, shardId);
        this.phase1FileNames = phase1FileNames;
        this.phase1FileSizes = phase1FileSizes;
        this.phase1ExistingFileNames = phase1ExistingFileNames;
        this.phase1ExistingFileSizes = phase1ExistingFileSizes;
        this.totalTranslogOps = totalTranslogOps;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeStringCollection(this.phase1FileNames);
        out.writeCollection(this.phase1FileSizes, StreamOutput::writeVLong);
        out.writeStringCollection(this.phase1ExistingFileNames);
        out.writeCollection(this.phase1ExistingFileSizes, StreamOutput::writeVLong);
        out.writeVInt(this.totalTranslogOps);
    }
}

