/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.mapper;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.lucene.index.LeafReaderContext;
import org.elasticsearch.common.document.DocumentField;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.search.fetch.StoredFieldsSpec;
import org.elasticsearch.search.lookup.Source;

public interface ValueFetcher {
    public static final ValueFetcher EMPTY = new ValueFetcher(){

        @Override
        public List<Object> fetchValues(Source source, int doc, List<Object> ignoredValues) {
            return List.of();
        }

        @Override
        public StoredFieldsSpec storedFieldsSpec() {
            return StoredFieldsSpec.NO_REQUIREMENTS;
        }
    };

    public List<Object> fetchValues(Source var1, int var2, List<Object> var3) throws IOException;

    @Nullable
    default public DocumentField fetchDocumentField(String docName, Source lookup, int doc) throws IOException {
        ArrayList<Object> ignoredValues = new ArrayList<Object>();
        List<Object> values = this.fetchValues(lookup, doc, ignoredValues);
        if (values.isEmpty() && ignoredValues.isEmpty()) {
            return null;
        }
        return new DocumentField(docName, values, ignoredValues);
    }

    default public void setNextReader(LeafReaderContext context) {
    }

    public StoredFieldsSpec storedFieldsSpec();

    public static ValueFetcher singleton(final Object value) {
        return new ValueFetcher(){

            @Override
            public List<Object> fetchValues(Source source, int doc, List<Object> ignoredValues) {
                return List.of(value);
            }

            @Override
            public StoredFieldsSpec storedFieldsSpec() {
                return StoredFieldsSpec.NO_REQUIREMENTS;
            }
        };
    }
}

