/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.fieldvisitor;

import java.io.IOException;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.lucene.codecs.StoredFieldsReader;
import org.apache.lucene.index.LeafReader;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.StoredFields;
import org.elasticsearch.common.CheckedBiConsumer;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.lucene.index.SequentialStoredFieldsLeafReader;
import org.elasticsearch.index.fieldvisitor.CustomFieldsVisitor;
import org.elasticsearch.index.fieldvisitor.FieldsVisitor;
import org.elasticsearch.index.fieldvisitor.LeafStoredFieldLoader;
import org.elasticsearch.search.fetch.StoredFieldsSpec;

public abstract class StoredFieldLoader {
    public abstract LeafStoredFieldLoader getLoader(LeafReaderContext var1, int[] var2) throws IOException;

    public abstract List<String> fieldsToLoad();

    public static StoredFieldLoader fromSpec(StoredFieldsSpec spec) {
        if (spec.noRequirements()) {
            return StoredFieldLoader.empty();
        }
        return StoredFieldLoader.create(spec.requiresSource(), spec.requiredStoredFields());
    }

    public static StoredFieldLoader create(boolean loadSource, Set<String> fields) {
        return StoredFieldLoader.create(loadSource, fields, false);
    }

    public static StoredFieldLoader create(final boolean loadSource, final Set<String> fields, final boolean forceSequentialReader) {
        if (!loadSource && fields.isEmpty()) {
            return StoredFieldLoader.empty();
        }
        final List<String> fieldsToLoad = StoredFieldLoader.fieldsToLoad(loadSource, fields);
        return new StoredFieldLoader(){

            @Override
            public LeafStoredFieldLoader getLoader(LeafReaderContext ctx, int[] docs) throws IOException {
                return new ReaderStoredFieldLoader(forceSequentialReader ? StoredFieldLoader.sequentialReader(ctx) : StoredFieldLoader.reader(ctx, docs), loadSource, fields);
            }

            @Override
            public List<String> fieldsToLoad() {
                return fieldsToLoad;
            }
        };
    }

    public static StoredFieldLoader fromSpecSequential(final StoredFieldsSpec spec) {
        if (spec.noRequirements()) {
            return StoredFieldLoader.empty();
        }
        final List<String> fieldsToLoad = StoredFieldLoader.fieldsToLoad(spec.requiresSource(), spec.requiredStoredFields());
        return new StoredFieldLoader(){

            @Override
            public LeafStoredFieldLoader getLoader(LeafReaderContext ctx, int[] docs) throws IOException {
                return new ReaderStoredFieldLoader(StoredFieldLoader.sequentialReader(ctx), spec.requiresSource(), spec.requiredStoredFields());
            }

            @Override
            public List<String> fieldsToLoad() {
                return fieldsToLoad;
            }
        };
    }

    public static StoredFieldLoader sequentialSource() {
        return new StoredFieldLoader(){

            @Override
            public LeafStoredFieldLoader getLoader(LeafReaderContext ctx, int[] docs) throws IOException {
                return new ReaderStoredFieldLoader(StoredFieldLoader.sequentialReader(ctx), true, Set.of());
            }

            @Override
            public List<String> fieldsToLoad() {
                return List.of();
            }
        };
    }

    public static StoredFieldLoader empty() {
        return new StoredFieldLoader(){

            @Override
            public LeafStoredFieldLoader getLoader(LeafReaderContext ctx, int[] docs) {
                return new EmptyStoredFieldLoader();
            }

            @Override
            public List<String> fieldsToLoad() {
                return List.of();
            }
        };
    }

    private static CheckedBiConsumer<Integer, FieldsVisitor, IOException> reader(LeafReaderContext ctx, int[] docs) throws IOException {
        LeafReader leafReader = ctx.reader();
        if (docs != null && docs.length > 10 && StoredFieldLoader.hasSequentialDocs(docs)) {
            return StoredFieldLoader.sequentialReader(ctx);
        }
        StoredFields storedFields = leafReader.storedFields();
        return (arg_0, arg_1) -> ((StoredFields)storedFields).document(arg_0, arg_1);
    }

    private static CheckedBiConsumer<Integer, FieldsVisitor, IOException> sequentialReader(LeafReaderContext ctx) throws IOException {
        LeafReader leafReader = ctx.reader();
        if (leafReader instanceof SequentialStoredFieldsLeafReader) {
            SequentialStoredFieldsLeafReader lf = (SequentialStoredFieldsLeafReader)leafReader;
            return (arg_0, arg_1) -> ((StoredFieldsReader)lf.getSequentialStoredFieldsReader()).document(arg_0, arg_1);
        }
        return (arg_0, arg_1) -> ((StoredFields)leafReader.storedFields()).document(arg_0, arg_1);
    }

    private static List<String> fieldsToLoad(boolean loadSource, Set<String> fields) {
        HashSet<String> fieldsToLoad = new HashSet<String>();
        fieldsToLoad.add("_id");
        fieldsToLoad.add("_routing");
        if (loadSource) {
            fieldsToLoad.add("_source");
        }
        fieldsToLoad.addAll(fields);
        return fieldsToLoad.stream().sorted().toList();
    }

    private static boolean hasSequentialDocs(int[] docs) {
        return docs.length > 0 && docs[docs.length - 1] - docs[0] == docs.length - 1;
    }

    private static class ReaderStoredFieldLoader
    implements LeafStoredFieldLoader {
        private final CheckedBiConsumer<Integer, FieldsVisitor, IOException> reader;
        private final CustomFieldsVisitor visitor;
        private int doc = -1;

        ReaderStoredFieldLoader(CheckedBiConsumer<Integer, FieldsVisitor, IOException> reader, boolean loadSource, Set<String> fields) {
            this.reader = reader;
            this.visitor = new CustomFieldsVisitor(fields, loadSource);
        }

        @Override
        public void advanceTo(int doc) throws IOException {
            if (doc != this.doc) {
                this.visitor.reset();
                this.reader.accept(doc, this.visitor);
                this.doc = doc;
            }
        }

        @Override
        public BytesReference source() {
            return this.visitor.source();
        }

        @Override
        public String id() {
            return this.visitor.id();
        }

        @Override
        public String routing() {
            return this.visitor.routing();
        }

        @Override
        public Map<String, List<Object>> storedFields() {
            return this.visitor.fields();
        }
    }

    private static class EmptyStoredFieldLoader
    implements LeafStoredFieldLoader {
        private EmptyStoredFieldLoader() {
        }

        @Override
        public void advanceTo(int doc) throws IOException {
        }

        @Override
        public BytesReference source() {
            return null;
        }

        @Override
        public String id() {
            return null;
        }

        @Override
        public String routing() {
            return null;
        }

        @Override
        public Map<String, List<Object>> storedFields() {
            return Collections.emptyMap();
        }
    }
}

