/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.fielddata.fieldcomparator;

import java.io.IOException;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.sandbox.document.HalfFloatPoint;
import org.apache.lucene.search.LeafFieldComparator;
import org.apache.lucene.search.Pruning;
import org.apache.lucene.search.comparators.NumericComparator;
import org.apache.lucene.util.BitUtil;

public class HalfFloatComparator
extends NumericComparator<Float> {
    private final float[] values;
    protected float topValue;
    protected float bottom;

    public HalfFloatComparator(int numHits, String field, Float missingValue, boolean reverse, Pruning pruning) {
        super(field, (Number)Float.valueOf(missingValue != null ? missingValue.floatValue() : 0.0f), reverse, pruning, 2);
        this.values = new float[numHits];
    }

    public int compare(int slot1, int slot2) {
        return Float.compare(this.values[slot1], this.values[slot2]);
    }

    public void setTopValue(Float value) {
        super.setTopValue((Number)value);
        this.topValue = value.floatValue();
    }

    public Float value(int slot) {
        return Float.valueOf(this.values[slot]);
    }

    protected long missingValueAsComparableLong() {
        return HalfFloatPoint.halfFloatToSortableShort((float)((Float)this.missingValue).floatValue());
    }

    protected long sortableBytesToLong(byte[] bytes) {
        short x = BitUtil.VH_BE_SHORT.get(bytes, 0);
        return (short)(x ^ 0x8000);
    }

    public LeafFieldComparator getLeafComparator(LeafReaderContext context) throws IOException {
        return new HalfFloatLeafComparator(context);
    }

    public class HalfFloatLeafComparator
    extends NumericComparator.NumericLeafComparator {
        public HalfFloatLeafComparator(LeafReaderContext context) throws IOException {
            super((NumericComparator)HalfFloatComparator.this, context);
        }

        private float getValueForDoc(int doc) throws IOException {
            if (this.docValues.advanceExact(doc)) {
                return Float.intBitsToFloat((int)this.docValues.longValue());
            }
            return ((Float)HalfFloatComparator.this.missingValue).floatValue();
        }

        public void setBottom(int slot) throws IOException {
            HalfFloatComparator.this.bottom = HalfFloatComparator.this.values[slot];
            super.setBottom(slot);
        }

        public int compareBottom(int doc) throws IOException {
            return Float.compare(HalfFloatComparator.this.bottom, this.getValueForDoc(doc));
        }

        public int compareTop(int doc) throws IOException {
            return Float.compare(HalfFloatComparator.this.topValue, this.getValueForDoc(doc));
        }

        public void copy(int slot, int doc) throws IOException {
            HalfFloatComparator.this.values[slot] = this.getValueForDoc(doc);
            super.copy(slot, doc);
        }

        protected long bottomAsComparableLong() {
            return HalfFloatPoint.halfFloatToSortableShort((float)HalfFloatComparator.this.bottom);
        }

        protected long topAsComparableLong() {
            return HalfFloatPoint.halfFloatToSortableShort((float)HalfFloatComparator.this.topValue);
        }
    }
}

