/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.fielddata;

import java.io.IOException;
import org.apache.lucene.search.Scorable;
import org.apache.lucene.util.NumericUtils;
import org.elasticsearch.common.lucene.ScorerAware;
import org.elasticsearch.index.fielddata.AbstractSortedNumericDocValues;
import org.elasticsearch.index.fielddata.SortedNumericDoubleValues;

final class SortableLongBitsSortedNumericDocValues
extends AbstractSortedNumericDocValues
implements ScorerAware {
    private final SortedNumericDoubleValues values;

    SortableLongBitsSortedNumericDocValues(SortedNumericDoubleValues values) {
        this.values = values;
    }

    public boolean advanceExact(int target) throws IOException {
        return this.values.advanceExact(target);
    }

    public long nextValue() throws IOException {
        return NumericUtils.doubleToSortableLong((double)this.values.nextValue());
    }

    public int docValueCount() {
        return this.values.docValueCount();
    }

    public SortedNumericDoubleValues getDoubleValues() {
        return this.values;
    }

    @Override
    public void setScorer(Scorable scorer) {
        SortedNumericDoubleValues sortedNumericDoubleValues = this.values;
        if (sortedNumericDoubleValues instanceof ScorerAware) {
            ScorerAware aware = (ScorerAware)((Object)sortedNumericDoubleValues);
            aware.setScorer(scorer);
        }
    }
}

