/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.transport;

import java.net.ConnectException;
import java.nio.channels.ClosedChannelException;
import org.apache.logging.log4j.Level;

public class NetworkExceptionHelper {
    public static boolean isConnectException(Throwable e) {
        return e instanceof ConnectException;
    }

    public static Level getCloseConnectionExceptionLevel(Throwable e, boolean rstOnClose) {
        if (e instanceof ClosedChannelException) {
            return Level.DEBUG;
        }
        String message = e.getMessage();
        if (message != null) {
            if (message.contains("Connection timed out")) {
                return Level.INFO;
            }
            if (message.contains("Connection reset")) {
                return rstOnClose ? Level.DEBUG : Level.INFO;
            }
            if (message.contains("Broken pipe")) {
                return Level.INFO;
            }
            if (message.contains("connection was aborted") || message.contains("forcibly closed")) {
                return Level.INFO;
            }
            if (message.equals("Socket is closed") || message.equals("Socket closed")) {
                return Level.DEBUG;
            }
            if (message.equals("SSLEngine closed already")) {
                return Level.DEBUG;
            }
        }
        return Level.OFF;
    }
}

