/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.settings;

import org.apache.logging.log4j.Logger;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.block.ClusterBlocks;
import org.elasticsearch.cluster.metadata.Metadata;
import org.elasticsearch.common.settings.BaseSettingsUpdater;
import org.elasticsearch.common.settings.ClusterSettings;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.core.Tuple;

public final class SettingsUpdater
extends BaseSettingsUpdater {
    final Settings.Builder transientUpdates = Settings.builder();
    final Settings.Builder persistentUpdates = Settings.builder();

    public SettingsUpdater(ClusterSettings scopedSettings) {
        super(scopedSettings);
    }

    public synchronized Settings getTransientUpdates() {
        return this.transientUpdates.build();
    }

    public synchronized Settings getPersistentUpdate() {
        return this.persistentUpdates.build();
    }

    public synchronized ClusterState updateSettings(ClusterState currentState, Settings transientToApply, Settings persistentToApply, Logger logger) {
        ClusterState clusterState;
        boolean changed = false;
        Tuple<Settings, Settings> partitionedTransientSettings = this.partitionKnownAndValidSettings(currentState.metadata().transientSettings(), "transient", logger);
        Settings knownAndValidTransientSettings = (Settings)partitionedTransientSettings.v1();
        Settings unknownOrInvalidTransientSettings = (Settings)partitionedTransientSettings.v2();
        Settings.Builder transientSettings = Settings.builder().put(knownAndValidTransientSettings);
        changed |= this.scopedSettings.updateDynamicSettings(transientToApply, transientSettings, this.transientUpdates, "transient");
        Tuple<Settings, Settings> partitionedPersistentSettings = this.partitionKnownAndValidSettings(currentState.metadata().persistentSettings(), "persistent", logger);
        Settings knownAndValidPersistentSettings = (Settings)partitionedPersistentSettings.v1();
        Settings unknownOrInvalidPersistentSettings = (Settings)partitionedPersistentSettings.v2();
        Settings.Builder persistentSettings = Settings.builder().put(knownAndValidPersistentSettings);
        if (changed |= this.scopedSettings.updateDynamicSettings(persistentToApply, persistentSettings, this.persistentUpdates, "persistent")) {
            boolean updatedReadOnlyAllowDelete;
            boolean updatedReadOnly;
            Settings transientFinalSettings = transientSettings.build();
            Settings persistentFinalSettings = persistentSettings.build();
            this.scopedSettings.validate(transientFinalSettings, true);
            this.scopedSettings.validate(persistentFinalSettings, true);
            Metadata.Builder metadata = Metadata.builder(currentState.metadata()).transientSettings(Settings.builder().put(transientFinalSettings).put(unknownOrInvalidTransientSettings).build()).persistentSettings(Settings.builder().put(persistentFinalSettings).put(unknownOrInvalidPersistentSettings).build());
            ClusterBlocks.Builder blocks = ClusterBlocks.builder().blocks(currentState.blocks());
            boolean bl = updatedReadOnly = Metadata.SETTING_READ_ONLY_SETTING.get(metadata.persistentSettings()) != false || Metadata.SETTING_READ_ONLY_SETTING.get(metadata.transientSettings()) != false;
            if (updatedReadOnly) {
                blocks.addGlobalBlock(Metadata.CLUSTER_READ_ONLY_BLOCK);
            } else {
                blocks.removeGlobalBlock(Metadata.CLUSTER_READ_ONLY_BLOCK);
            }
            boolean bl2 = updatedReadOnlyAllowDelete = Metadata.SETTING_READ_ONLY_ALLOW_DELETE_SETTING.get(metadata.persistentSettings()) != false || Metadata.SETTING_READ_ONLY_ALLOW_DELETE_SETTING.get(metadata.transientSettings()) != false;
            if (updatedReadOnlyAllowDelete) {
                blocks.addGlobalBlock(Metadata.CLUSTER_READ_ONLY_ALLOW_DELETE_BLOCK);
            } else {
                blocks.removeGlobalBlock(Metadata.CLUSTER_READ_ONLY_ALLOW_DELETE_BLOCK);
            }
            clusterState = ClusterState.builder(currentState).metadata(metadata).blocks(blocks).build();
        } else {
            clusterState = currentState;
        }
        Settings settings = clusterState.metadata().settings();
        this.scopedSettings.validateUpdate(settings);
        return clusterState;
    }
}

