/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.regex;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.automaton.Automata;
import org.apache.lucene.util.automaton.Automaton;
import org.apache.lucene.util.automaton.CharacterRunAutomaton;
import org.apache.lucene.util.automaton.Operations;
import org.elasticsearch.common.Strings;
import org.elasticsearch.core.Predicates;

public class Regex {
    public static final int UNICODE_CHARACTER_CLASS = 256;

    public static boolean isSimpleMatchPattern(String str) {
        return str.indexOf(42) != -1;
    }

    public static boolean isMatchAllPattern(String str) {
        return str.equals("*");
    }

    public static boolean isSuffixMatchPattern(String str) {
        return str.length() > 1 && str.indexOf(42) == str.length() - 1;
    }

    public static boolean isSuffixWildcard(String str) {
        return Regex.isSuffixMatchPattern(str) && str.endsWith(".*");
    }

    public static Automaton simpleMatchToNonDeterminizedAutomaton(String pattern) {
        ArrayList<Automaton> automata = new ArrayList<Automaton>();
        int previous = 0;
        int i = pattern.indexOf(42);
        while (i != -1) {
            automata.add(Automata.makeString((String)pattern.substring(previous, i)));
            automata.add(Automata.makeAnyString());
            previous = i + 1;
            i = pattern.indexOf(42, i + 1);
        }
        automata.add(Automata.makeString((String)pattern.substring(previous)));
        return Operations.concatenate(automata);
    }

    public static Automaton simpleMatchToAutomaton(String pattern) {
        return Operations.determinize((Automaton)Regex.simpleMatchToNonDeterminizedAutomaton(pattern), (int)10000);
    }

    public static Automaton simpleMatchToNonDeterminizedAutomaton(String ... patterns) {
        if (patterns.length < 1) {
            throw new IllegalArgumentException("There must be at least one pattern, zero given");
        }
        ArrayList<BytesRef> simpleStrings = new ArrayList<BytesRef>();
        ArrayList<Automaton> automata = new ArrayList<Automaton>();
        ArrayList<BytesRef> prefixes = new ArrayList<BytesRef>();
        for (String pattern : patterns) {
            if (Regex.isSuffixWildcard(pattern) && pattern.length() < 1000) {
                prefixes.add(new BytesRef((CharSequence)pattern.substring(0, pattern.length() - 1)));
                continue;
            }
            if (Regex.isSimpleMatchPattern(pattern) || pattern.length() >= 1000) {
                automata.add(Regex.simpleMatchToNonDeterminizedAutomaton(pattern));
                continue;
            }
            simpleStrings.add(new BytesRef((CharSequence)pattern));
        }
        if (!simpleStrings.isEmpty()) {
            Automaton simpleStringsAutomaton;
            if (simpleStrings.size() > 0) {
                Collections.sort(simpleStrings);
                simpleStringsAutomaton = Automata.makeStringUnion(simpleStrings);
            } else {
                simpleStringsAutomaton = Automata.makeString((String)((BytesRef)simpleStrings.get(0)).utf8ToString());
            }
            if (automata.isEmpty() && prefixes.isEmpty()) {
                return simpleStringsAutomaton;
            }
            automata.add(simpleStringsAutomaton);
        }
        if (!prefixes.isEmpty()) {
            ArrayList<Automaton> prefixAutomaton = new ArrayList<Automaton>();
            Collections.sort(prefixes);
            prefixAutomaton.add(Automata.makeStringUnion(prefixes));
            prefixAutomaton.add(Automata.makeAnyString());
            automata.add(Operations.concatenate(prefixAutomaton));
        }
        return Operations.union(automata);
    }

    public static Automaton simpleMatchToAutomaton(String ... patterns) {
        return Operations.determinize((Automaton)Regex.simpleMatchToNonDeterminizedAutomaton(patterns), (int)10000);
    }

    public static Predicate<String> simpleMatcher(String ... patterns) {
        if (patterns == null || patterns.length == 0) {
            return Predicates.never();
        }
        boolean hasWildcard = false;
        for (String pattern : patterns) {
            if (Regex.isMatchAllPattern(pattern)) {
                return Predicates.always();
            }
            if (!Regex.isSimpleMatchPattern(pattern)) continue;
            hasWildcard = true;
            break;
        }
        if (patterns.length == 1) {
            if (hasWildcard) {
                return str -> Regex.simpleMatch(patterns[0], str);
            }
            return patterns[0]::equals;
        }
        if (!hasWildcard) {
            return Set.copyOf(Arrays.asList(patterns))::contains;
        }
        Automaton automaton = Regex.simpleMatchToAutomaton(patterns);
        return arg_0 -> ((CharacterRunAutomaton)new CharacterRunAutomaton(automaton)).run(arg_0);
    }

    public static boolean simpleMatch(String pattern, String str) {
        return Regex.simpleMatch(pattern, str, false);
    }

    public static boolean simpleMatch(String pattern, String str, boolean caseInsensitive) {
        if (pattern == null || str == null) {
            return false;
        }
        if (caseInsensitive) {
            pattern = Strings.toLowercaseAscii(pattern);
            str = Strings.toLowercaseAscii(str);
        }
        return Regex.simpleMatchWithNormalizedStrings(pattern, str);
    }

    private static boolean simpleMatchWithNormalizedStrings(String pattern, String str) {
        int firstIndex = pattern.indexOf(42);
        if (firstIndex == -1) {
            return pattern.equals(str);
        }
        if (firstIndex == 0) {
            if (pattern.length() == 1) {
                return true;
            }
            int nextIndex = pattern.indexOf(42, firstIndex + 1);
            if (nextIndex == -1) {
                return str.regionMatches(str.length() - pattern.length() + 1, pattern, 1, pattern.length() - 1);
            }
            if (nextIndex == 1) {
                int wildcards;
                for (wildcards = nextIndex + 1; wildcards < pattern.length() && pattern.charAt(wildcards) == '*'; ++wildcards) {
                }
                return Regex.simpleMatchWithNormalizedStrings(pattern.substring(wildcards - 1), str);
            }
            String part = pattern.substring(1, nextIndex);
            int partIndex = str.indexOf(part);
            while (partIndex != -1) {
                if (Regex.simpleMatchWithNormalizedStrings(pattern.substring(nextIndex), str.substring(partIndex + part.length()))) {
                    return true;
                }
                partIndex = str.indexOf(part, partIndex + 1);
            }
            return false;
        }
        return str.regionMatches(0, pattern, 0, firstIndex) && (firstIndex == pattern.length() - 1 || Regex.simpleMatchWithNormalizedStrings(pattern.substring(firstIndex), str.substring(firstIndex)));
    }

    public static boolean simpleMatch(String[] patterns, String str) {
        if (patterns != null) {
            for (String pattern : patterns) {
                if (!Regex.simpleMatch(pattern, str)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean simpleMatch(List<String> patterns, String str) {
        return patterns != null && Regex.simpleMatch(patterns.toArray(Strings.EMPTY_ARRAY), str);
    }

    public static Pattern compile(String regex, String flags) {
        try {
            int pFlags = flags == null ? 0 : Regex.flagsFromString(flags);
            return Pattern.compile(regex, pFlags);
        }
        catch (OutOfMemoryError e) {
            if (e.getMessage().equals("Pattern too complex")) {
                throw new IllegalArgumentException("Too complex regex pattern", e);
            }
            throw e;
        }
    }

    public static int flagsFromString(String flags) {
        int pFlags = 0;
        for (String s : Strings.delimitedListToStringArray(flags, "|")) {
            if (s.isEmpty()) continue;
            if ("CASE_INSENSITIVE".equals(s = s.toUpperCase(Locale.ROOT))) {
                pFlags |= 2;
                continue;
            }
            if ("MULTILINE".equals(s)) {
                pFlags |= 8;
                continue;
            }
            if ("DOTALL".equals(s)) {
                pFlags |= 0x20;
                continue;
            }
            if ("UNICODE_CASE".equals(s)) {
                pFlags |= 0x40;
                continue;
            }
            if ("CANON_EQ".equals(s)) {
                pFlags |= 0x80;
                continue;
            }
            if ("UNIX_LINES".equals(s)) {
                pFlags |= 1;
                continue;
            }
            if ("LITERAL".equals(s)) {
                pFlags |= 0x10;
                continue;
            }
            if ("COMMENTS".equals(s)) {
                pFlags |= 4;
                continue;
            }
            if ("UNICODE_CHAR_CLASS".equals(s) || "UNICODE_CHARACTER_CLASS".equals(s)) {
                pFlags |= 0x100;
                continue;
            }
            throw new IllegalArgumentException("Unknown regex flag [" + s + "]");
        }
        return pFlags;
    }

    public static String flagsToString(int flags) {
        StringBuilder sb = new StringBuilder();
        if ((flags & 2) != 0) {
            sb.append("CASE_INSENSITIVE|");
        }
        if ((flags & 8) != 0) {
            sb.append("MULTILINE|");
        }
        if ((flags & 0x20) != 0) {
            sb.append("DOTALL|");
        }
        if ((flags & 0x40) != 0) {
            sb.append("UNICODE_CASE|");
        }
        if ((flags & 0x80) != 0) {
            sb.append("CANON_EQ|");
        }
        if ((flags & 1) != 0) {
            sb.append("UNIX_LINES|");
        }
        if ((flags & 0x10) != 0) {
            sb.append("LITERAL|");
        }
        if ((flags & 4) != 0) {
            sb.append("COMMENTS|");
        }
        if ((flags & 0x100) != 0) {
            sb.append("UNICODE_CHAR_CLASS|");
        }
        return sb.toString();
    }
}

