/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.logging;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.Objects;
import java.util.zip.GZIPOutputStream;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.common.ReferenceDocs;
import org.elasticsearch.common.unit.ByteSizeUnit;

public class ChunkedLoggingStream
extends OutputStream {
    static final int CHUNK_SIZE = ByteSizeUnit.KB.toIntBytes(2L);
    private final Logger logger;
    private final Level level;
    private final String prefix;
    private final ReferenceDocs referenceDocs;
    private int chunk;
    private int offset;
    private boolean closed;
    private final byte[] buffer = new byte[CHUNK_SIZE];

    public static OutputStream create(Logger logger, Level level, String prefix, ReferenceDocs referenceDocs) throws IOException {
        return new GZIPOutputStream(Base64.getEncoder().wrap(new ChunkedLoggingStream(logger, level, prefix, referenceDocs)));
    }

    ChunkedLoggingStream(Logger logger, Level level, String prefix, ReferenceDocs referenceDocs) {
        this.logger = Objects.requireNonNull(logger);
        this.level = Objects.requireNonNull(level);
        this.prefix = Objects.requireNonNull(prefix);
        this.referenceDocs = Objects.requireNonNull(referenceDocs);
    }

    private void flushBuffer() {
        assert (this.closed || this.offset == CHUNK_SIZE) : this.offset;
        assert (this.offset >= 0 && this.offset <= CHUNK_SIZE) : this.offset;
        ++this.chunk;
        String chunkString = new String(this.buffer, 0, this.offset, StandardCharsets.ISO_8859_1);
        this.offset = 0;
        if (this.closed && this.chunk == 1) {
            this.logger.log(this.level, "{} (gzip compressed and base64-encoded; for details see {}): {}", (Object)this.prefix, (Object)this.referenceDocs, (Object)chunkString);
        } else {
            this.logger.log(this.level, "{} [part {}]: {}", (Object)this.prefix, (Object)this.chunk, (Object)chunkString);
        }
    }

    @Override
    public void write(int b) throws IOException {
        assert (!this.closed);
        if (this.offset == CHUNK_SIZE) {
            this.flushBuffer();
        }
        this.buffer[this.offset] = (byte)b;
        assert (ChunkedLoggingStream.assertSafeByte(this.buffer[this.offset]));
        ++this.offset;
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        assert (!this.closed);
        assert (ChunkedLoggingStream.assertSafeBytes(b, off, len));
        while (len > 0) {
            if (this.offset == CHUNK_SIZE) {
                this.flushBuffer();
            }
            int copyLen = Math.min(len, CHUNK_SIZE - this.offset);
            System.arraycopy(b, off, this.buffer, this.offset, copyLen);
            this.offset += copyLen;
            off += copyLen;
            len -= copyLen;
        }
    }

    @Override
    public void close() throws IOException {
        if (!this.closed) {
            this.closed = true;
            this.flushBuffer();
            if (this.chunk > 1) {
                this.logger.log(this.level, "{} (gzip compressed, base64-encoded, and split into {} parts on preceding log lines; for details see {})", (Object)this.prefix, (Object)this.chunk, (Object)this.referenceDocs);
            }
        }
    }

    private static boolean assertSafeBytes(byte[] b, int off, int len) {
        for (int i = off; i < off + len; ++i) {
            ChunkedLoggingStream.assertSafeByte(b[i]);
        }
        return true;
    }

    private static boolean assertSafeByte(byte b) {
        assert (32 <= b && b < 127);
        return true;
    }
}

