/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.io.stream;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.elasticsearch.common.io.stream.FilterStreamInput;
import org.elasticsearch.common.io.stream.NamedWriteable;
import org.elasticsearch.common.io.stream.NamedWriteableRegistry;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.Writeable;

public class NamedWriteableAwareStreamInput
extends FilterStreamInput {
    private final NamedWriteableRegistry namedWriteableRegistry;

    public NamedWriteableAwareStreamInput(StreamInput delegate, NamedWriteableRegistry namedWriteableRegistry) {
        super(delegate);
        this.namedWriteableRegistry = namedWriteableRegistry;
    }

    @Override
    public <C extends NamedWriteable> C readNamedWriteable(Class<C> categoryClass) throws IOException {
        String name = this.readString();
        return this.readNamedWriteable(categoryClass, name);
    }

    @Override
    public <T extends NamedWriteable> List<T> readNamedWriteableCollectionAsList(Class<T> categoryClass) throws IOException {
        int count = this.readArraySize();
        if (count == 0) {
            return Collections.emptyList();
        }
        Map<String, Writeable.Reader<?>> readers = this.namedWriteableRegistry.getReaders(categoryClass);
        ArrayList<NamedWriteable> builder = new ArrayList<NamedWriteable>(count);
        for (int i = 0; i < count; ++i) {
            String name = this.readString();
            builder.add((NamedWriteable)NamedWriteableRegistry.getReader(categoryClass, name, readers).read(this));
        }
        return builder;
    }

    @Override
    public <C extends NamedWriteable> C readNamedWriteable(Class<C> categoryClass, String name) throws IOException {
        Writeable.Reader<C> reader = this.namedWriteableRegistry.getReader(categoryClass, name);
        NamedWriteable c = (NamedWriteable)reader.read(this);
        if (c == null) {
            NamedWriteableAwareStreamInput.throwOnNullRead(reader);
        }
        assert (NamedWriteableAwareStreamInput.assertNameMatches(name, c));
        return (C)c;
    }

    private static <C extends NamedWriteable> boolean assertNameMatches(String name, C c) {
        assert (name.equals(c.getWriteableName())) : String.valueOf(c) + " claims to have a different name [" + c.getWriteableName() + "] than it was read from [" + name + "].";
        return true;
    }

    @Override
    public NamedWriteableRegistry namedWriteableRegistry() {
        return this.namedWriteableRegistry;
    }
}

