/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.geo;

public interface SpatialPoint
extends Comparable<SpatialPoint> {
    public double getX();

    public double getY();

    default public String toWKT() {
        return "POINT (" + this.getX() + " " + this.getY() + ")";
    }

    @Override
    default public int compareTo(SpatialPoint other) {
        if (this.getClass().equals(other.getClass())) {
            double xd = this.getX() - other.getX();
            double yd = this.getY() - other.getY();
            return xd == 0.0 ? this.comparison(yd) : this.comparison(xd);
        }
        return this.getClass().getSimpleName().compareTo(other.getClass().getSimpleName());
    }

    private int comparison(double delta) {
        return delta == 0.0 ? 0 : (delta < 0.0 ? -1 : 1);
    }
}

