/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.cli;

import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Pattern;
import joptsimple.OptionSet;
import joptsimple.OptionSpec;
import joptsimple.util.KeyValuePair;
import org.elasticsearch.Build;
import org.elasticsearch.cli.Command;
import org.elasticsearch.cli.ProcessInfo;
import org.elasticsearch.cli.Terminal;
import org.elasticsearch.cli.UserException;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.core.SuppressForbidden;
import org.elasticsearch.env.Environment;
import org.elasticsearch.node.InternalSettingsPreparer;

public abstract class EnvironmentAwareCommand
extends Command {
    private static final String DOCKER_UPPERCASE_SETTING_PREFIX = "ES_SETTING_";
    private static final Pattern DOCKER_LOWERCASE_SETTING_REGEX = Pattern.compile("[-a-z0-9_]+(\\.[-a-z0-9_]+)+");
    private final OptionSpec<KeyValuePair> settingOption;

    public EnvironmentAwareCommand(String description) {
        super(description);
        this.settingOption = this.parser.accepts("E", "Configure a setting").withRequiredArg().ofType(KeyValuePair.class);
    }

    protected void execute(Terminal terminal, OptionSet options, ProcessInfo processInfo) throws Exception {
        this.execute(terminal, options, this.createEnv(options, processInfo), processInfo);
    }

    private static void putDockerEnvSettings(Map<String, String> settings, Map<String, String> envVars) {
        for (Map.Entry<String, String> envVar : envVars.entrySet()) {
            String key = envVar.getKey();
            if (DOCKER_LOWERCASE_SETTING_REGEX.matcher(key).matches()) {
                settings.put(key, envVar.getValue());
                continue;
            }
            if (!key.startsWith(DOCKER_UPPERCASE_SETTING_PREFIX)) continue;
            key = key.substring(DOCKER_UPPERCASE_SETTING_PREFIX.length());
            key = key.replace('_', '.');
            key = key.replace("..", "_");
            key = key.toLowerCase(Locale.ROOT);
            settings.put(key, envVar.getValue());
        }
    }

    protected Environment createEnv(OptionSet options, ProcessInfo processInfo) throws UserException {
        HashMap<String, String> settings = new HashMap<String, String>();
        for (KeyValuePair kvp : this.settingOption.values(options)) {
            if (kvp.value.isEmpty()) {
                throw new UserException(64, "setting [" + kvp.key + "] must not be empty");
            }
            if (settings.containsKey(kvp.key)) {
                String message = String.format(Locale.ROOT, "setting [%s] set twice via command line -E", kvp.key);
                throw new UserException(64, message);
            }
            settings.put(kvp.key, kvp.value);
        }
        if (this.getBuildType() == Build.Type.DOCKER) {
            EnvironmentAwareCommand.putDockerEnvSettings(settings, processInfo.envVars());
        }
        EnvironmentAwareCommand.putSystemPropertyIfSettingIsMissing(processInfo.sysprops(), settings, "path.data", "es.path.data");
        EnvironmentAwareCommand.putSystemPropertyIfSettingIsMissing(processInfo.sysprops(), settings, "path.home", "es.path.home");
        EnvironmentAwareCommand.putSystemPropertyIfSettingIsMissing(processInfo.sysprops(), settings, "path.logs", "es.path.logs");
        String esPathConf = (String)processInfo.sysprops().get("es.path.conf");
        if (esPathConf == null) {
            throw new UserException(78, "the system property [es.path.conf] must be set");
        }
        return InternalSettingsPreparer.prepareEnvironment(Settings.EMPTY, settings, EnvironmentAwareCommand.getConfigPath(esPathConf), () -> (String)processInfo.envVars().get("HOSTNAME"));
    }

    protected Build.Type getBuildType() {
        return Build.current().type();
    }

    @SuppressForbidden(reason="need path to construct environment")
    private static Path getConfigPath(String pathConf) {
        return Paths.get(pathConf, new String[0]);
    }

    private static void putSystemPropertyIfSettingIsMissing(Map<String, String> sysprops, Map<String, String> settings, String setting, String key) throws UserException {
        String value = sysprops.get(key);
        if (value != null) {
            if (settings.containsKey(setting)) {
                String message = String.format(Locale.ROOT, "setting [%s] found via command-line -E and system property [%s]", setting, key);
                throw new UserException(64, message);
            }
            settings.put(setting, value);
        }
    }

    public abstract void execute(Terminal var1, OptionSet var2, Environment var3, ProcessInfo var4) throws Exception;
}

