/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.cluster.routing.allocation;

import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.common.settings.ClusterSettings;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.unit.ByteSizeValue;
import org.elasticsearch.common.unit.RelativeByteSizeValue;
import org.elasticsearch.core.Strings;
import org.elasticsearch.core.TimeValue;

public class DiskThresholdSettings
implements Writeable {
    public static final Setting<Boolean> CLUSTER_ROUTING_ALLOCATION_DISK_THRESHOLD_ENABLED_SETTING = Setting.boolSetting("cluster.routing.allocation.disk.threshold_enabled", true, Setting.Property.OperatorDynamic, Setting.Property.NodeScope);
    public static final Setting<RelativeByteSizeValue> CLUSTER_ROUTING_ALLOCATION_LOW_DISK_WATERMARK_SETTING = new Setting<RelativeByteSizeValue>("cluster.routing.allocation.disk.watermark.low", "85%", s -> RelativeByteSizeValue.parseRelativeByteSizeValue(s, "cluster.routing.allocation.disk.watermark.low"), new WatermarkValidator(), Setting.Property.Dynamic, Setting.Property.NodeScope);
    public static final Setting<ByteSizeValue> CLUSTER_ROUTING_ALLOCATION_LOW_DISK_MAX_HEADROOM_SETTING = new Setting<ByteSizeValue>("cluster.routing.allocation.disk.watermark.low.max_headroom", settings -> {
        if (CLUSTER_ROUTING_ALLOCATION_LOW_DISK_WATERMARK_SETTING.exists((Settings)settings)) {
            return "-1";
        }
        return "200GB";
    }, s -> ByteSizeValue.parseBytesSizeValue(s, "cluster.routing.allocation.disk.watermark.low.max_headroom"), new MaxHeadroomValidator(), Setting.Property.Dynamic, Setting.Property.NodeScope);
    public static final Setting<RelativeByteSizeValue> CLUSTER_ROUTING_ALLOCATION_HIGH_DISK_WATERMARK_SETTING = new Setting<RelativeByteSizeValue>("cluster.routing.allocation.disk.watermark.high", "90%", s -> RelativeByteSizeValue.parseRelativeByteSizeValue(s, "cluster.routing.allocation.disk.watermark.high"), new WatermarkValidator(), Setting.Property.Dynamic, Setting.Property.NodeScope);
    public static final Setting<ByteSizeValue> CLUSTER_ROUTING_ALLOCATION_HIGH_DISK_MAX_HEADROOM_SETTING = new Setting<ByteSizeValue>("cluster.routing.allocation.disk.watermark.high.max_headroom", settings -> {
        if (CLUSTER_ROUTING_ALLOCATION_HIGH_DISK_WATERMARK_SETTING.exists((Settings)settings)) {
            return "-1";
        }
        return "150GB";
    }, s -> ByteSizeValue.parseBytesSizeValue(s, "cluster.routing.allocation.disk.watermark.high.max_headroom"), new MaxHeadroomValidator(), Setting.Property.Dynamic, Setting.Property.NodeScope);
    public static final Setting<RelativeByteSizeValue> CLUSTER_ROUTING_ALLOCATION_DISK_FLOOD_STAGE_WATERMARK_SETTING = new Setting<RelativeByteSizeValue>("cluster.routing.allocation.disk.watermark.flood_stage", "95%", s -> RelativeByteSizeValue.parseRelativeByteSizeValue(s, "cluster.routing.allocation.disk.watermark.flood_stage"), new WatermarkValidator(), Setting.Property.Dynamic, Setting.Property.NodeScope);
    public static final Setting<ByteSizeValue> CLUSTER_ROUTING_ALLOCATION_DISK_FLOOD_STAGE_MAX_HEADROOM_SETTING = new Setting<ByteSizeValue>("cluster.routing.allocation.disk.watermark.flood_stage.max_headroom", settings -> {
        if (CLUSTER_ROUTING_ALLOCATION_DISK_FLOOD_STAGE_WATERMARK_SETTING.exists((Settings)settings)) {
            return "-1";
        }
        return "100GB";
    }, s -> ByteSizeValue.parseBytesSizeValue(s, "cluster.routing.allocation.disk.watermark.flood_stage.max_headroom"), new MaxHeadroomValidator(), Setting.Property.Dynamic, Setting.Property.NodeScope);
    public static final Setting<RelativeByteSizeValue> CLUSTER_ROUTING_ALLOCATION_DISK_FLOOD_STAGE_FROZEN_WATERMARK_SETTING = new Setting<RelativeByteSizeValue>("cluster.routing.allocation.disk.watermark.flood_stage.frozen", "95%", s -> RelativeByteSizeValue.parseRelativeByteSizeValue(s, "cluster.routing.allocation.disk.watermark.flood_stage.frozen"), Setting.Property.Dynamic, Setting.Property.NodeScope);
    public static final Setting<ByteSizeValue> CLUSTER_ROUTING_ALLOCATION_DISK_FLOOD_STAGE_FROZEN_MAX_HEADROOM_SETTING = new Setting<ByteSizeValue>("cluster.routing.allocation.disk.watermark.flood_stage.frozen.max_headroom", settings -> {
        if (CLUSTER_ROUTING_ALLOCATION_DISK_FLOOD_STAGE_FROZEN_WATERMARK_SETTING.exists((Settings)settings)) {
            return "-1";
        }
        return "20GB";
    }, s -> ByteSizeValue.parseBytesSizeValue(s, "cluster.routing.allocation.disk.watermark.flood_stage.frozen.max_headroom"), new MaxHeadroomValidator(), Setting.Property.Dynamic, Setting.Property.NodeScope);
    public static final Setting<TimeValue> CLUSTER_ROUTING_ALLOCATION_REROUTE_INTERVAL_SETTING = Setting.positiveTimeSetting("cluster.routing.allocation.disk.reroute_interval", TimeValue.timeValueSeconds((long)60L), Setting.Property.Dynamic, Setting.Property.NodeScope);
    private static final List<Setting<?>> WATERMARK_VALIDATOR_SETTINGS_LIST = List.of(CLUSTER_ROUTING_ALLOCATION_LOW_DISK_WATERMARK_SETTING, CLUSTER_ROUTING_ALLOCATION_HIGH_DISK_WATERMARK_SETTING, CLUSTER_ROUTING_ALLOCATION_DISK_FLOOD_STAGE_WATERMARK_SETTING);
    private static final List<Setting<?>> MAX_HEADROOM_VALIDATOR_SETTINGS_LIST = List.of(CLUSTER_ROUTING_ALLOCATION_LOW_DISK_MAX_HEADROOM_SETTING, CLUSTER_ROUTING_ALLOCATION_HIGH_DISK_MAX_HEADROOM_SETTING, CLUSTER_ROUTING_ALLOCATION_DISK_FLOOD_STAGE_MAX_HEADROOM_SETTING, CLUSTER_ROUTING_ALLOCATION_DISK_FLOOD_STAGE_FROZEN_MAX_HEADROOM_SETTING, CLUSTER_ROUTING_ALLOCATION_LOW_DISK_WATERMARK_SETTING, CLUSTER_ROUTING_ALLOCATION_DISK_FLOOD_STAGE_FROZEN_WATERMARK_SETTING);
    private volatile RelativeByteSizeValue lowStageWatermark;
    private volatile ByteSizeValue lowStageMaxHeadroom;
    private volatile RelativeByteSizeValue highStageWatermark;
    private volatile ByteSizeValue highStageMaxHeadroom;
    private volatile RelativeByteSizeValue floodStageWatermark;
    private volatile ByteSizeValue floodStageMaxHeadroom;
    private volatile RelativeByteSizeValue frozenFloodStageWatermark;
    private volatile ByteSizeValue frozenFloodStageMaxHeadroom;
    private volatile boolean enabled;
    private volatile TimeValue rerouteInterval;

    public DiskThresholdSettings(Settings settings, ClusterSettings clusterSettings) {
        this.setLowWatermark(CLUSTER_ROUTING_ALLOCATION_LOW_DISK_WATERMARK_SETTING.get(settings));
        this.setLowStageMaxHeadroom(CLUSTER_ROUTING_ALLOCATION_LOW_DISK_MAX_HEADROOM_SETTING.get(settings));
        this.setHighWatermark(CLUSTER_ROUTING_ALLOCATION_HIGH_DISK_WATERMARK_SETTING.get(settings));
        this.setHighStageMaxHeadroom(CLUSTER_ROUTING_ALLOCATION_HIGH_DISK_MAX_HEADROOM_SETTING.get(settings));
        this.setFloodStageWatermark(CLUSTER_ROUTING_ALLOCATION_DISK_FLOOD_STAGE_WATERMARK_SETTING.get(settings));
        this.setFloodStageMaxHeadroom(CLUSTER_ROUTING_ALLOCATION_DISK_FLOOD_STAGE_MAX_HEADROOM_SETTING.get(settings));
        this.setFrozenFloodStageWatermark(CLUSTER_ROUTING_ALLOCATION_DISK_FLOOD_STAGE_FROZEN_WATERMARK_SETTING.get(settings));
        this.setFrozenFloodStageMaxHeadroom(CLUSTER_ROUTING_ALLOCATION_DISK_FLOOD_STAGE_FROZEN_MAX_HEADROOM_SETTING.get(settings));
        this.rerouteInterval = CLUSTER_ROUTING_ALLOCATION_REROUTE_INTERVAL_SETTING.get(settings);
        this.enabled = CLUSTER_ROUTING_ALLOCATION_DISK_THRESHOLD_ENABLED_SETTING.get(settings);
        clusterSettings.addSettingsUpdateConsumer(CLUSTER_ROUTING_ALLOCATION_LOW_DISK_WATERMARK_SETTING, this::setLowWatermark);
        clusterSettings.addSettingsUpdateConsumer(CLUSTER_ROUTING_ALLOCATION_LOW_DISK_MAX_HEADROOM_SETTING, this::setLowStageMaxHeadroom);
        clusterSettings.addSettingsUpdateConsumer(CLUSTER_ROUTING_ALLOCATION_HIGH_DISK_WATERMARK_SETTING, this::setHighWatermark);
        clusterSettings.addSettingsUpdateConsumer(CLUSTER_ROUTING_ALLOCATION_HIGH_DISK_MAX_HEADROOM_SETTING, this::setHighStageMaxHeadroom);
        clusterSettings.addSettingsUpdateConsumer(CLUSTER_ROUTING_ALLOCATION_DISK_FLOOD_STAGE_WATERMARK_SETTING, this::setFloodStageWatermark);
        clusterSettings.addSettingsUpdateConsumer(CLUSTER_ROUTING_ALLOCATION_DISK_FLOOD_STAGE_MAX_HEADROOM_SETTING, this::setFloodStageMaxHeadroom);
        clusterSettings.addSettingsUpdateConsumer(CLUSTER_ROUTING_ALLOCATION_DISK_FLOOD_STAGE_FROZEN_WATERMARK_SETTING, this::setFrozenFloodStageWatermark);
        clusterSettings.addSettingsUpdateConsumer(CLUSTER_ROUTING_ALLOCATION_DISK_FLOOD_STAGE_FROZEN_MAX_HEADROOM_SETTING, this::setFrozenFloodStageMaxHeadroom);
        clusterSettings.addSettingsUpdateConsumer(CLUSTER_ROUTING_ALLOCATION_REROUTE_INTERVAL_SETTING, this::setRerouteInterval);
        clusterSettings.addSettingsUpdateConsumer(CLUSTER_ROUTING_ALLOCATION_DISK_THRESHOLD_ENABLED_SETTING, this::setEnabled);
    }

    public DiskThresholdSettings(RelativeByteSizeValue lowStageWatermark, ByteSizeValue lowStageMaxHeadroom, RelativeByteSizeValue highStageWatermark, ByteSizeValue highStageMaxHeadroom, RelativeByteSizeValue floodStageWatermark, ByteSizeValue floodStageMaxHeadroom, RelativeByteSizeValue frozenFloodStageWatermark, ByteSizeValue frozenFloodStageMaxHeadroom) {
        this.lowStageWatermark = lowStageWatermark;
        this.lowStageMaxHeadroom = lowStageMaxHeadroom;
        this.highStageWatermark = highStageWatermark;
        this.highStageMaxHeadroom = highStageMaxHeadroom;
        this.floodStageWatermark = floodStageWatermark;
        this.floodStageMaxHeadroom = floodStageMaxHeadroom;
        this.frozenFloodStageWatermark = frozenFloodStageWatermark;
        this.frozenFloodStageMaxHeadroom = frozenFloodStageMaxHeadroom;
    }

    public static DiskThresholdSettings readFrom(StreamInput in) throws IOException {
        RelativeByteSizeValue lowStageWatermark = RelativeByteSizeValue.readFrom(in);
        ByteSizeValue lowStageMaxHeadroom = ByteSizeValue.readFrom(in);
        RelativeByteSizeValue highStageWatermark = RelativeByteSizeValue.readFrom(in);
        ByteSizeValue highStageMaxHeadroom = ByteSizeValue.readFrom(in);
        RelativeByteSizeValue floodStageWatermark = RelativeByteSizeValue.readFrom(in);
        ByteSizeValue floodStageMaxHeadroom = ByteSizeValue.readFrom(in);
        RelativeByteSizeValue frozenFloodStageWatermark = RelativeByteSizeValue.readFrom(in);
        ByteSizeValue frozenFloodStageMaxHeadroom = ByteSizeValue.readFrom(in);
        return new DiskThresholdSettings(lowStageWatermark, lowStageMaxHeadroom, highStageWatermark, highStageMaxHeadroom, floodStageWatermark, floodStageMaxHeadroom, frozenFloodStageWatermark, frozenFloodStageMaxHeadroom);
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        this.lowStageWatermark.writeTo(out);
        this.lowStageMaxHeadroom.writeTo(out);
        this.highStageWatermark.writeTo(out);
        this.highStageMaxHeadroom.writeTo(out);
        this.floodStageWatermark.writeTo(out);
        this.floodStageMaxHeadroom.writeTo(out);
        this.frozenFloodStageWatermark.writeTo(out);
        this.frozenFloodStageMaxHeadroom.writeTo(out);
    }

    private void setRerouteInterval(TimeValue rerouteInterval) {
        this.rerouteInterval = rerouteInterval;
    }

    private void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    private void setLowWatermark(RelativeByteSizeValue lowWatermark) {
        this.lowStageWatermark = lowWatermark;
    }

    private void setLowStageMaxHeadroom(ByteSizeValue maxHeadroom) {
        this.lowStageMaxHeadroom = maxHeadroom;
    }

    private void setHighWatermark(RelativeByteSizeValue highWatermark) {
        this.highStageWatermark = highWatermark;
    }

    private void setHighStageMaxHeadroom(ByteSizeValue maxHeadroom) {
        this.highStageMaxHeadroom = maxHeadroom;
    }

    private void setFloodStageWatermark(RelativeByteSizeValue floodStage) {
        this.floodStageWatermark = floodStage;
    }

    private void setFloodStageMaxHeadroom(ByteSizeValue maxHeadroom) {
        this.floodStageMaxHeadroom = maxHeadroom;
    }

    private void setFrozenFloodStageWatermark(RelativeByteSizeValue floodStage) {
        this.frozenFloodStageWatermark = floodStage;
    }

    private void setFrozenFloodStageMaxHeadroom(ByteSizeValue maxHeadroom) {
        this.frozenFloodStageMaxHeadroom = maxHeadroom;
    }

    private static ByteSizeValue getFreeBytesThreshold(ByteSizeValue total, RelativeByteSizeValue watermark, ByteSizeValue maxHeadroom) {
        if (watermark.isAbsolute()) {
            return watermark.getAbsolute();
        }
        return ByteSizeValue.subtract(total, watermark.calculateValue(total, maxHeadroom));
    }

    public ByteSizeValue getFreeBytesThresholdLowStage(ByteSizeValue total) {
        return DiskThresholdSettings.getFreeBytesThreshold(total, this.lowStageWatermark, this.lowStageMaxHeadroom);
    }

    public ByteSizeValue getFreeBytesThresholdHighStage(ByteSizeValue total) {
        return DiskThresholdSettings.getFreeBytesThreshold(total, this.highStageWatermark, this.highStageMaxHeadroom);
    }

    public ByteSizeValue getFreeBytesThresholdFloodStage(ByteSizeValue total) {
        return DiskThresholdSettings.getFreeBytesThreshold(total, this.floodStageWatermark, this.floodStageMaxHeadroom);
    }

    public ByteSizeValue getFreeBytesThresholdFrozenFloodStage(ByteSizeValue total) {
        return DiskThresholdSettings.getFreeBytesThreshold(total, this.frozenFloodStageWatermark, this.frozenFloodStageMaxHeadroom);
    }

    private static ByteSizeValue getMinimumTotalSizeForBelowWatermark(ByteSizeValue used, RelativeByteSizeValue watermark, ByteSizeValue maxHeadroom) {
        if (watermark.isAbsolute()) {
            return ByteSizeValue.add(watermark.getAbsolute(), used);
        }
        double percentThreshold = watermark.getRatio().getAsPercent();
        if (percentThreshold >= 0.0 && percentThreshold < 100.0) {
            ByteSizeValue totalBytes = ByteSizeValue.ofBytes((long)Math.ceil((double)(100L * used.getBytes()) / percentThreshold));
            if (!maxHeadroom.equals(ByteSizeValue.MINUS_ONE)) {
                totalBytes = ByteSizeValue.min(totalBytes, ByteSizeValue.add(used, maxHeadroom));
            }
            return totalBytes;
        }
        return used;
    }

    public ByteSizeValue getMinimumTotalSizeForBelowLowWatermark(ByteSizeValue used) {
        return DiskThresholdSettings.getMinimumTotalSizeForBelowWatermark(used, this.lowStageWatermark, this.lowStageMaxHeadroom);
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public TimeValue getRerouteInterval() {
        return this.rerouteInterval;
    }

    private static String describeThreshold(ByteSizeValue total, RelativeByteSizeValue watermark, ByteSizeValue maxHeadroom, boolean includeSettingKey, String watermarkSettingKey, String maxHeadroomSettingKey) {
        if (watermark.isAbsolute()) {
            return includeSettingKey ? watermarkSettingKey + "=" + watermark.getStringRep() : watermark.getStringRep();
        }
        if (watermark.calculateValue(total, maxHeadroom).equals(watermark.calculateValue(total, null))) {
            String value = watermark.getStringRep();
            return includeSettingKey ? watermarkSettingKey + "=" + value : value;
        }
        return includeSettingKey ? maxHeadroomSettingKey + "=" + maxHeadroom.getStringRep() : "max_headroom=" + maxHeadroom.getStringRep();
    }

    public String describeLowThreshold(ByteSizeValue total, boolean includeSettingKey) {
        return DiskThresholdSettings.describeThreshold(total, this.lowStageWatermark, this.lowStageMaxHeadroom, includeSettingKey, CLUSTER_ROUTING_ALLOCATION_LOW_DISK_WATERMARK_SETTING.getKey(), CLUSTER_ROUTING_ALLOCATION_LOW_DISK_MAX_HEADROOM_SETTING.getKey());
    }

    public String describeHighThreshold(ByteSizeValue total, boolean includeSettingKey) {
        return DiskThresholdSettings.describeThreshold(total, this.highStageWatermark, this.highStageMaxHeadroom, includeSettingKey, CLUSTER_ROUTING_ALLOCATION_HIGH_DISK_WATERMARK_SETTING.getKey(), CLUSTER_ROUTING_ALLOCATION_HIGH_DISK_MAX_HEADROOM_SETTING.getKey());
    }

    public String describeFloodStageThreshold(ByteSizeValue total, boolean includeSettingKey) {
        return DiskThresholdSettings.describeThreshold(total, this.floodStageWatermark, this.floodStageMaxHeadroom, includeSettingKey, CLUSTER_ROUTING_ALLOCATION_DISK_FLOOD_STAGE_WATERMARK_SETTING.getKey(), CLUSTER_ROUTING_ALLOCATION_DISK_FLOOD_STAGE_MAX_HEADROOM_SETTING.getKey());
    }

    public String describeFrozenFloodStageThreshold(ByteSizeValue total, boolean includeSettingKey) {
        return DiskThresholdSettings.describeThreshold(total, this.frozenFloodStageWatermark, this.frozenFloodStageMaxHeadroom, includeSettingKey, CLUSTER_ROUTING_ALLOCATION_DISK_FLOOD_STAGE_FROZEN_WATERMARK_SETTING.getKey(), CLUSTER_ROUTING_ALLOCATION_DISK_FLOOD_STAGE_FROZEN_MAX_HEADROOM_SETTING.getKey());
    }

    static class WatermarkValidator
    implements Setting.Validator<RelativeByteSizeValue> {
        WatermarkValidator() {
        }

        @Override
        public void validate(RelativeByteSizeValue value) {
        }

        @Override
        public void validate(RelativeByteSizeValue value, Map<Setting<?>, Object> settings) {
            RelativeByteSizeValue low = (RelativeByteSizeValue)settings.get(CLUSTER_ROUTING_ALLOCATION_LOW_DISK_WATERMARK_SETTING);
            RelativeByteSizeValue high = (RelativeByteSizeValue)settings.get(CLUSTER_ROUTING_ALLOCATION_HIGH_DISK_WATERMARK_SETTING);
            RelativeByteSizeValue flood = (RelativeByteSizeValue)settings.get(CLUSTER_ROUTING_ALLOCATION_DISK_FLOOD_STAGE_WATERMARK_SETTING);
            if (!(low.isAbsolute() || high.isAbsolute() || flood.isAbsolute())) {
                double lowWatermarkThreshold = low.getRatio().getAsPercent();
                double highWatermarkThreshold = high.getRatio().getAsPercent();
                double floodThreshold = flood.getRatio().getAsPercent();
                if (lowWatermarkThreshold > highWatermarkThreshold) {
                    throw new IllegalArgumentException("low disk watermark [" + low.getStringRep() + "] more than high disk watermark [" + high.getStringRep() + "]");
                }
                if (highWatermarkThreshold > floodThreshold) {
                    throw new IllegalArgumentException("high disk watermark [" + high.getStringRep() + "] more than flood stage disk watermark [" + flood.getStringRep() + "]");
                }
            } else if (low.isAbsolute() && high.isAbsolute() && flood.isAbsolute()) {
                ByteSizeValue lowWatermarkBytes = low.getAbsolute();
                ByteSizeValue highWatermarkBytes = high.getAbsolute();
                ByteSizeValue floodStageBytes = flood.getAbsolute();
                if (lowWatermarkBytes.getBytes() < highWatermarkBytes.getBytes()) {
                    throw new IllegalArgumentException("low disk watermark [" + low.getStringRep() + "] less than high disk watermark [" + high.getStringRep() + "]");
                }
                if (highWatermarkBytes.getBytes() < floodStageBytes.getBytes()) {
                    throw new IllegalArgumentException("high disk watermark [" + high.getStringRep() + "] less than flood stage disk watermark [" + flood.getStringRep() + "]");
                }
            } else {
                String message = Strings.format((String)"unable to consistently parse [%s=%s], [%s=%s], and [%s=%s] as percentage or bytes", (Object[])new Object[]{CLUSTER_ROUTING_ALLOCATION_LOW_DISK_WATERMARK_SETTING.getKey(), low.getStringRep(), CLUSTER_ROUTING_ALLOCATION_HIGH_DISK_WATERMARK_SETTING.getKey(), high.getStringRep(), CLUSTER_ROUTING_ALLOCATION_DISK_FLOOD_STAGE_WATERMARK_SETTING.getKey(), flood.getStringRep()});
                throw new IllegalArgumentException(message);
            }
        }

        @Override
        public Iterator<Setting<?>> settings() {
            return WATERMARK_VALIDATOR_SETTINGS_LIST.iterator();
        }
    }

    static class MaxHeadroomValidator
    implements Setting.Validator<ByteSizeValue> {
        MaxHeadroomValidator() {
        }

        @Override
        public void validate(ByteSizeValue value) {
        }

        @Override
        public void validate(ByteSizeValue value, Map<Setting<?>, Object> settings, boolean isPresent) {
            if (isPresent && value.equals(ByteSizeValue.MINUS_ONE)) {
                throw new IllegalArgumentException("setting a headroom value to less than 0 is not supported");
            }
            ByteSizeValue lowHeadroom = (ByteSizeValue)settings.get(CLUSTER_ROUTING_ALLOCATION_LOW_DISK_MAX_HEADROOM_SETTING);
            ByteSizeValue highHeadroom = (ByteSizeValue)settings.get(CLUSTER_ROUTING_ALLOCATION_HIGH_DISK_MAX_HEADROOM_SETTING);
            ByteSizeValue floodHeadroom = (ByteSizeValue)settings.get(CLUSTER_ROUTING_ALLOCATION_DISK_FLOOD_STAGE_MAX_HEADROOM_SETTING);
            ByteSizeValue frozenFloodHeadroom = (ByteSizeValue)settings.get(CLUSTER_ROUTING_ALLOCATION_DISK_FLOOD_STAGE_FROZEN_MAX_HEADROOM_SETTING);
            RelativeByteSizeValue low = (RelativeByteSizeValue)settings.get(CLUSTER_ROUTING_ALLOCATION_LOW_DISK_WATERMARK_SETTING);
            if (!(!low.isAbsolute() || lowHeadroom.equals(ByteSizeValue.MINUS_ONE) && highHeadroom.equals(ByteSizeValue.MINUS_ONE) && floodHeadroom.equals(ByteSizeValue.MINUS_ONE))) {
                throw new IllegalArgumentException("At least one of the disk max headroom settings is set [low=" + lowHeadroom.getStringRep() + ", high=" + highHeadroom.getStringRep() + ", flood=" + floodHeadroom.getStringRep() + "], while the disk watermark values are set to absolute values instead of ratios/percentages, e.g., the low watermark is [" + low.getStringRep() + "]");
            }
            RelativeByteSizeValue frozenFlood = (RelativeByteSizeValue)settings.get(CLUSTER_ROUTING_ALLOCATION_DISK_FLOOD_STAGE_FROZEN_WATERMARK_SETTING);
            if (frozenFlood.isAbsolute() && !frozenFloodHeadroom.equals(ByteSizeValue.MINUS_ONE)) {
                throw new IllegalArgumentException("The frozen flood stage disk max headroom setting is set [" + frozenFloodHeadroom.getStringRep() + "], while the frozen flood stage disk watermark setting is set to an absolute value instead of a ratio/percentage [" + frozenFlood.getStringRep() + "]");
            }
            if (!lowHeadroom.equals(ByteSizeValue.MINUS_ONE) && highHeadroom.equals(ByteSizeValue.MINUS_ONE)) {
                throw new IllegalArgumentException("high disk max headroom [" + highHeadroom.getStringRep() + "] is not set, while the low disk max headroom is set [" + lowHeadroom.getStringRep() + "]");
            }
            if (!highHeadroom.equals(ByteSizeValue.MINUS_ONE) && floodHeadroom.equals(ByteSizeValue.MINUS_ONE)) {
                throw new IllegalArgumentException("flood disk max headroom [" + floodHeadroom.getStringRep() + "] is not set, while the high disk max headroom is set [" + highHeadroom.getStringRep() + "]");
            }
            if (highHeadroom.compareTo(lowHeadroom) > 0 && !lowHeadroom.equals(ByteSizeValue.MINUS_ONE)) {
                throw new IllegalArgumentException("high disk max headroom [" + highHeadroom.getStringRep() + "] more than low disk max headroom [" + lowHeadroom.getStringRep() + "]");
            }
            if (floodHeadroom.compareTo(highHeadroom) > 0 && !highHeadroom.equals(ByteSizeValue.MINUS_ONE)) {
                throw new IllegalArgumentException("flood disk max headroom [" + floodHeadroom.getStringRep() + "] more than high disk max headroom [" + highHeadroom.getStringRep() + "]");
            }
        }

        @Override
        public Iterator<Setting<?>> settings() {
            return MAX_HEADROOM_VALIDATOR_SETTINGS_LIST.iterator();
        }
    }
}

