/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.cluster.metadata;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.ElasticsearchStatusException;
import org.elasticsearch.ResourceAlreadyExistsException;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.admin.indices.create.CreateIndexClusterStateUpdateRequest;
import org.elasticsearch.action.admin.indices.rollover.MetadataRolloverService;
import org.elasticsearch.action.support.ActiveShardCount;
import org.elasticsearch.action.support.ActiveShardsObserver;
import org.elasticsearch.action.support.master.AcknowledgedResponse;
import org.elasticsearch.cluster.AckedClusterStateUpdateTask;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.ClusterStateUpdateTask;
import org.elasticsearch.cluster.metadata.AliasMetadata;
import org.elasticsearch.cluster.metadata.ComposableIndexTemplate;
import org.elasticsearch.cluster.metadata.DataStream;
import org.elasticsearch.cluster.metadata.DataStreamFailureStoreDefinition;
import org.elasticsearch.cluster.metadata.DataStreamLifecycle;
import org.elasticsearch.cluster.metadata.DataStreamOptions;
import org.elasticsearch.cluster.metadata.IndexMetadata;
import org.elasticsearch.cluster.metadata.MetadataCreateIndexService;
import org.elasticsearch.cluster.metadata.MetadataIndexTemplateService;
import org.elasticsearch.cluster.metadata.ProjectId;
import org.elasticsearch.cluster.metadata.ProjectMetadata;
import org.elasticsearch.cluster.routing.allocation.allocator.AllocationActionListener;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.Priority;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.core.SuppressForbidden;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.index.Index;
import org.elasticsearch.index.IndexMode;
import org.elasticsearch.index.mapper.MappingLookup;
import org.elasticsearch.index.mapper.MetadataFieldMapper;
import org.elasticsearch.indices.SystemDataStreamDescriptor;
import org.elasticsearch.indices.SystemIndexDescriptor;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.threadpool.ThreadPool;

public class MetadataCreateDataStreamService {
    private static final Logger logger = LogManager.getLogger(MetadataCreateDataStreamService.class);
    public static final String FAILURE_STORE_REFRESH_INTERVAL_SETTING_NAME = "data_streams.failure_store.refresh_interval";
    private final ThreadPool threadPool;
    private final ClusterService clusterService;
    private final MetadataCreateIndexService metadataCreateIndexService;
    private final boolean isDslOnlyMode;

    public MetadataCreateDataStreamService(ThreadPool threadPool, ClusterService clusterService, MetadataCreateIndexService metadataCreateIndexService) {
        this.threadPool = threadPool;
        this.clusterService = clusterService;
        this.metadataCreateIndexService = metadataCreateIndexService;
        this.isDslOnlyMode = DataStreamLifecycle.isDataStreamsLifecycleOnlyMode(clusterService.getSettings());
    }

    public void createDataStream(final CreateDataStreamClusterStateUpdateRequest request, ActionListener<AcknowledgedResponse> finalListener) {
        final AtomicReference firstBackingIndexRef = new AtomicReference();
        final AtomicReference firstFailureStoreRef = new AtomicReference();
        ActionListener<AcknowledgedResponse> listener = finalListener.delegateFailureAndWrap((l, response) -> {
            if (response.isAcknowledged()) {
                String[] stringArray;
                String firstBackingIndexName = (String)firstBackingIndexRef.get();
                assert (firstBackingIndexName != null);
                String firstFailureStoreName = (String)firstFailureStoreRef.get();
                if (firstFailureStoreName == null) {
                    String[] stringArray2 = new String[1];
                    stringArray = stringArray2;
                    stringArray2[0] = firstBackingIndexName;
                } else {
                    String[] stringArray3 = new String[2];
                    stringArray3[0] = firstBackingIndexName;
                    stringArray = stringArray3;
                    stringArray3[1] = firstFailureStoreName;
                }
                String[] waitForIndices = stringArray;
                ActiveShardsObserver.waitForActiveShards(this.clusterService, request.projectId(), waitForIndices, ActiveShardCount.DEFAULT, request.masterNodeTimeout(), l.map(shardsAcked -> AcknowledgedResponse.TRUE));
            } else {
                l.onResponse(AcknowledgedResponse.FALSE);
            }
        });
        final AllocationActionListener<AcknowledgedResponse> delegate = new AllocationActionListener<AcknowledgedResponse>(listener, this.threadPool.getThreadContext());
        this.submitUnbatchedTask("create-data-stream [" + request.name + "]", new AckedClusterStateUpdateTask(Priority.HIGH, request.masterNodeTimeout(), request.ackTimeout(), delegate.clusterStateUpdate()){

            @Override
            public ClusterState execute(ClusterState currentState) throws Exception {
                ClusterState clusterState = MetadataCreateDataStreamService.this.createDataStream(request, currentState, delegate.reroute(), false);
                DataStream createdDataStream = clusterState.metadata().getProject(request.projectId()).dataStreams().get(request.name);
                firstBackingIndexRef.set(createdDataStream.getIndices().get(0).getName());
                if (!createdDataStream.getFailureIndices().isEmpty()) {
                    firstFailureStoreRef.set(createdDataStream.getFailureIndices().get(0).getName());
                }
                return clusterState;
            }
        });
    }

    @SuppressForbidden(reason="legacy usage of unbatched task")
    private void submitUnbatchedTask(String source, ClusterStateUpdateTask task) {
        this.clusterService.submitUnbatchedStateUpdateTask(source, task);
    }

    public ClusterState createDataStream(CreateDataStreamClusterStateUpdateRequest request, ClusterState current, ActionListener<Void> rerouteListener, boolean initializeFailureStore) throws Exception {
        return MetadataCreateDataStreamService.createDataStream(this.metadataCreateIndexService, this.clusterService.getSettings(), current, this.isDslOnlyMode, request, rerouteListener, initializeFailureStore);
    }

    static ClusterState createDataStream(MetadataCreateIndexService metadataCreateIndexService, Settings settings, ClusterState currentState, boolean isDslOnlyMode, CreateDataStreamClusterStateUpdateRequest request, ActionListener<Void> rerouteListener, boolean initializeFailureStore) throws Exception {
        return MetadataCreateDataStreamService.createDataStream(metadataCreateIndexService, settings, currentState, isDslOnlyMode, request, List.of(), null, rerouteListener, initializeFailureStore);
    }

    static ClusterState createDataStream(MetadataCreateIndexService metadataCreateIndexService, Settings settings, ClusterState currentState, boolean isDslOnlyMode, CreateDataStreamClusterStateUpdateRequest request, List<IndexMetadata> backingIndices, IndexMetadata writeIndex, ActionListener<Void> rerouteListener, boolean initializeFailureStore) throws Exception {
        String dataStreamName = request.name;
        SystemDataStreamDescriptor systemDataStreamDescriptor = request.systemDataStreamDescriptor();
        boolean isSystemDataStreamName = metadataCreateIndexService.getSystemIndices().isSystemDataStream(request.name);
        assert (isSystemDataStreamName && systemDataStreamDescriptor != null || !isSystemDataStreamName && systemDataStreamDescriptor == null) : "dataStream [" + request.name + "] is system but no system descriptor was provided!";
        Objects.requireNonNull(metadataCreateIndexService);
        Objects.requireNonNull(currentState);
        Objects.requireNonNull(backingIndices);
        ProjectMetadata currentProject = currentState.metadata().getProject(request.projectId());
        if (currentProject.dataStreams().containsKey(dataStreamName)) {
            throw new ResourceAlreadyExistsException("data_stream [" + dataStreamName + "] already exists", new Object[0]);
        }
        MetadataCreateIndexService.validateIndexOrAliasName(dataStreamName, (s1, s2) -> new IllegalArgumentException("data_stream [" + s1 + "] " + s2));
        if (!dataStreamName.toLowerCase(Locale.ROOT).equals(dataStreamName)) {
            throw new IllegalArgumentException("data_stream [" + dataStreamName + "] must be lowercase");
        }
        if (dataStreamName.startsWith(".ds-")) {
            throw new IllegalArgumentException("data_stream [" + dataStreamName + "] must not start with '.ds-'");
        }
        if (dataStreamName.startsWith(".fs-")) {
            throw new IllegalArgumentException("data_stream [" + dataStreamName + "] must not start with '.fs-'");
        }
        boolean isSystem = systemDataStreamDescriptor != null;
        ComposableIndexTemplate template = isSystem ? systemDataStreamDescriptor.getComposableIndexTemplate() : MetadataCreateDataStreamService.lookupTemplateForDataStream(dataStreamName, currentProject);
        long initialGeneration = 1L;
        DataStreamOptions dataStreamOptions = MetadataCreateDataStreamService.resolveDataStreamOptions(currentProject, systemDataStreamDescriptor, template, isSystem);
        IndexMetadata failureStoreIndex = null;
        if (initializeFailureStore) {
            String failureStoreIndexName = DataStream.getDefaultFailureStoreName(dataStreamName, 1L, request.startTime());
            currentState = MetadataCreateDataStreamService.createFailureStoreIndex(metadataCreateIndexService, "initialize_data_stream", request.projectId(), settings, currentState, request.startTime(), dataStreamName, template, systemDataStreamDescriptor, failureStoreIndexName, null);
            failureStoreIndex = currentState.metadata().getProject(request.projectId()).index(failureStoreIndexName);
        }
        if (writeIndex == null) {
            String firstBackingIndexName = DataStream.getDefaultBackingIndexName(dataStreamName, 1L, request.startTime());
            currentState = MetadataCreateDataStreamService.createBackingIndex(metadataCreateIndexService, currentState, request, rerouteListener, dataStreamName, systemDataStreamDescriptor, isSystem, template, firstBackingIndexName);
            writeIndex = currentState.metadata().getProject(request.projectId()).index(firstBackingIndexName);
        } else {
            rerouteListener.onResponse(null);
        }
        assert (writeIndex != null);
        assert (writeIndex.mapping() != null) : "no mapping found for backing index [" + writeIndex.getIndex().getName() + "]";
        assert (!initializeFailureStore || failureStoreIndex != null) : "failure store should have an initial index";
        assert (failureStoreIndex == null || failureStoreIndex.mapping() != null) : "no mapping found for failure store [" + failureStoreIndex.getIndex().getName() + "]";
        ProjectMetadata newProject = currentState.metadata().getProject(request.projectId());
        List dsBackingIndices = backingIndices.stream().map(IndexMetadata::getIndex).collect(Collectors.toCollection(ArrayList::new));
        dsBackingIndices.add(writeIndex.getIndex());
        boolean hidden = isSystem || template.getDataStreamTemplate().isHidden();
        IndexMode indexMode = newProject.retrieveIndexModeFromTemplate(template);
        DataStreamLifecycle lifecycle = MetadataCreateDataStreamService.resolveDataStreamLifecycle(currentProject, systemDataStreamDescriptor, template, isSystem);
        List<Index> failureIndices = failureStoreIndex == null ? List.of() : List.of(failureStoreIndex.getIndex());
        DataStream newDataStream = new DataStream(dataStreamName, 1L, template.metadata() != null ? Map.copyOf(template.metadata()) : null, Settings.EMPTY, ComposableIndexTemplate.EMPTY_MAPPINGS, hidden, false, isSystem, System::currentTimeMillis, template.getDataStreamTemplate().isAllowCustomRouting(), indexMode, lifecycle == null && isDslOnlyMode ? DataStreamLifecycle.DEFAULT_DATA_LIFECYCLE : lifecycle, dataStreamOptions, new DataStream.DataStreamIndices(".ds-", dsBackingIndices, false, null), new DataStream.DataStreamIndices(".fs-", failureIndices, !initializeFailureStore, null));
        ProjectMetadata.Builder builder = ProjectMetadata.builder(newProject).put(newDataStream);
        ArrayList<String> aliases = new ArrayList<String>();
        List<Map<String, AliasMetadata>> resolvedAliases = MetadataIndexTemplateService.resolveAliases(newProject, template);
        for (Map<String, AliasMetadata> resolvedAliasMap : resolvedAliases) {
            for (AliasMetadata alias : resolvedAliasMap.values()) {
                aliases.add(alias.getAlias());
                builder.put(alias.getAlias(), dataStreamName, alias.writeIndex(), alias.filter() == null ? null : alias.filter().string());
            }
        }
        logger.info("adding data stream [{}] with write index [{}], backing indices [{}], and aliases [{}]", (Object)dataStreamName, (Object)writeIndex.getIndex().getName(), (Object)Strings.arrayToCommaDelimitedString(backingIndices.stream().map(i -> i.getIndex().getName()).toArray()), (Object)Strings.collectionToCommaDelimitedString(aliases));
        return ClusterState.builder(currentState).putProjectMetadata(builder).build();
    }

    private static ClusterState createBackingIndex(MetadataCreateIndexService metadataCreateIndexService, ClusterState currentState, CreateDataStreamClusterStateUpdateRequest request, ActionListener<Void> rerouteListener, String dataStreamName, SystemDataStreamDescriptor systemDataStreamDescriptor, boolean isSystem, ComposableIndexTemplate template, String firstBackingIndexName) throws Exception {
        CreateIndexClusterStateUpdateRequest createIndexRequest = new CreateIndexClusterStateUpdateRequest("initialize_data_stream", request.projectId(), firstBackingIndexName, firstBackingIndexName).dataStreamName(dataStreamName).systemDataStreamDescriptor(systemDataStreamDescriptor).nameResolvedInstant(request.startTime()).performReroute(request.performReroute()).setMatchingTemplate(template);
        if (isSystem) {
            createIndexRequest.settings(SystemIndexDescriptor.DEFAULT_SETTINGS);
        } else {
            createIndexRequest.settings(MetadataRolloverService.HIDDEN_INDEX_SETTINGS);
        }
        try {
            currentState = metadataCreateIndexService.applyCreateIndexRequest(currentState, createIndexRequest, false, rerouteListener);
        }
        catch (ResourceAlreadyExistsException e) {
            throw new ElasticsearchStatusException("data stream could not be created because backing index [{}] already exists", RestStatus.BAD_REQUEST, e, firstBackingIndexName);
        }
        return currentState;
    }

    public static ClusterState createFailureStoreIndex(MetadataCreateIndexService metadataCreateIndexService, String cause, ProjectId projectId, Settings nodeSettings, ClusterState currentState, long nameResolvedInstant, String dataStreamName, ComposableIndexTemplate template, SystemDataStreamDescriptor systemDataStreamDescriptor, String failureStoreIndexName, @Nullable BiConsumer<ProjectMetadata.Builder, IndexMetadata> metadataTransformer) throws Exception {
        Settings indexSettings = DataStreamFailureStoreDefinition.buildFailureStoreIndexSettings(nodeSettings);
        CreateIndexClusterStateUpdateRequest createIndexRequest = new CreateIndexClusterStateUpdateRequest(cause, projectId, failureStoreIndexName, failureStoreIndexName).dataStreamName(dataStreamName).nameResolvedInstant(nameResolvedInstant).performReroute(false).setMatchingTemplate(template).settings(indexSettings).isFailureIndex(true).systemDataStreamDescriptor(systemDataStreamDescriptor);
        try {
            currentState = metadataCreateIndexService.applyCreateIndexRequest(currentState, createIndexRequest, false, metadataTransformer, AllocationActionListener.rerouteCompletionIsNotRequired());
        }
        catch (ResourceAlreadyExistsException e) {
            throw new ElasticsearchStatusException("data stream could not be created because failure store index [{}] already exists", RestStatus.BAD_REQUEST, e, failureStoreIndexName);
        }
        return currentState;
    }

    public static ComposableIndexTemplate lookupTemplateForDataStream(String dataStreamName, ProjectMetadata projectMetadata) {
        String v2Template = MetadataIndexTemplateService.findV2Template(projectMetadata, dataStreamName, false);
        if (v2Template == null) {
            throw new IllegalArgumentException("no matching index template found for data stream [" + dataStreamName + "]");
        }
        ComposableIndexTemplate composableIndexTemplate = projectMetadata.templatesV2().get(v2Template);
        if (composableIndexTemplate.getDataStreamTemplate() == null) {
            throw new IllegalArgumentException("matching index template [" + v2Template + "] for data stream [" + dataStreamName + "] has no data stream template");
        }
        return composableIndexTemplate;
    }

    public static void validateTimestampFieldMapping(MappingLookup mappingLookup) throws IOException {
        MetadataFieldMapper fieldMapper = (MetadataFieldMapper)mappingLookup.getMapper("_data_stream_timestamp");
        assert (fieldMapper != null) : "_data_stream_timestamp meta field mapper must exist";
        if (!mappingLookup.isDataStreamTimestampFieldEnabled()) {
            throw new IllegalStateException("[_data_stream_timestamp] meta field has been disabled");
        }
        fieldMapper.validate(mappingLookup);
    }

    private static DataStreamOptions resolveDataStreamOptions(ProjectMetadata project, SystemDataStreamDescriptor systemDataStreamDescriptor, ComposableIndexTemplate template, boolean isSystem) {
        DataStreamOptions.Builder builder = isSystem ? MetadataIndexTemplateService.resolveDataStreamOptions(template, systemDataStreamDescriptor.getComponentTemplates()) : MetadataIndexTemplateService.resolveDataStreamOptions(template, project.componentTemplates());
        return builder == null ? null : builder.build();
    }

    private static DataStreamLifecycle resolveDataStreamLifecycle(ProjectMetadata project, SystemDataStreamDescriptor systemDataStreamDescriptor, ComposableIndexTemplate template, boolean isSystem) {
        DataStreamLifecycle.Builder builder = isSystem ? MetadataIndexTemplateService.resolveLifecycle(template, systemDataStreamDescriptor.getComponentTemplates()) : MetadataIndexTemplateService.resolveLifecycle(template, project.componentTemplates());
        return builder == null ? null : builder.build();
    }

    public record CreateDataStreamClusterStateUpdateRequest(ProjectId projectId, String name, long startTime, @Nullable SystemDataStreamDescriptor systemDataStreamDescriptor, TimeValue masterNodeTimeout, TimeValue ackTimeout, boolean performReroute) {
        public CreateDataStreamClusterStateUpdateRequest {
            Objects.requireNonNull(name);
            Objects.requireNonNull(masterNodeTimeout);
            Objects.requireNonNull(ackTimeout);
        }

        public CreateDataStreamClusterStateUpdateRequest(ProjectId projectId, String name) {
            this(projectId, name, null, TimeValue.ZERO, TimeValue.ZERO, true);
        }

        public CreateDataStreamClusterStateUpdateRequest(ProjectId projectId, String name, SystemDataStreamDescriptor systemDataStreamDescriptor, TimeValue masterNodeTimeout, TimeValue ackTimeout, boolean performReroute) {
            this(projectId, name, System.currentTimeMillis(), systemDataStreamDescriptor, masterNodeTimeout, ackTimeout, performReroute);
        }

        public boolean isSystem() {
            return this.systemDataStreamDescriptor != null;
        }
    }
}

