/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.cluster;

import java.util.Objects;
import java.util.function.Consumer;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.block.ClusterBlocks;
import org.elasticsearch.cluster.metadata.ProjectId;
import org.elasticsearch.cluster.metadata.ProjectMetadata;
import org.elasticsearch.cluster.project.ProjectStateRegistry;
import org.elasticsearch.cluster.routing.RoutingTable;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.settings.Settings;

public final class ProjectState {
    private final ClusterState cluster;
    private final ProjectId project;
    private final ProjectMetadata projectMetadata;
    private final Settings projectSettings;
    private final RoutingTable routingTable;

    ProjectState(ClusterState clusterState, ProjectId projectId) {
        assert (clusterState.metadata().hasProject(projectId)) : "project-id [" + String.valueOf(projectId) + "] not found in " + String.valueOf(clusterState.metadata().projects().keySet());
        this.cluster = clusterState;
        this.project = projectId;
        this.projectMetadata = clusterState.metadata().getProject(projectId);
        this.projectSettings = ProjectStateRegistry.getProjectSettings(projectId, clusterState);
        this.routingTable = clusterState.routingTable(projectId);
    }

    public ProjectId projectId() {
        return this.project;
    }

    public ProjectMetadata metadata() {
        return this.projectMetadata;
    }

    public RoutingTable routingTable() {
        return this.routingTable;
    }

    public ClusterState cluster() {
        return this.cluster;
    }

    public ClusterBlocks blocks() {
        return this.cluster().blocks();
    }

    public Settings settings() {
        return this.projectSettings;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        ProjectState other = (ProjectState)obj;
        return this.cluster.equals(other.cluster) && this.project.equals(other.project);
    }

    public int hashCode() {
        return Objects.hash(this.cluster, this.project);
    }

    public ClusterState updatedState(Consumer<ProjectMetadata.Builder> projectBuilderConsumer) {
        ProjectMetadata.Builder projectBuilder = ProjectMetadata.builder(this.metadata());
        projectBuilderConsumer.accept(projectBuilder);
        return this.updatedState(projectBuilder.build());
    }

    public ClusterState updatedState(ProjectMetadata updatedProject) {
        return ClusterState.builder(this.cluster).metadata(this.cluster.metadata().withUpdatedProject(updatedProject)).build();
    }

    public ProjectState updateProject(ProjectMetadata updatedProject) {
        if (this.metadata() == updatedProject) {
            return this;
        }
        if (!this.project.equals(updatedProject.id())) {
            throw new IllegalArgumentException(Strings.format("Unable to update project state with project ID [%s] because updated project has ID [%s]", this.project, updatedProject.id()));
        }
        return new ProjectState(this.updatedState(updatedProject), this.project);
    }
}

