/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.support.master;

import java.io.IOException;
import java.util.Objects;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.support.master.MasterNodeRequest;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.core.TimeValue;

public abstract class AcknowledgedRequest<Request extends MasterNodeRequest<Request>>
extends MasterNodeRequest<Request> {
    public static final TimeValue DEFAULT_ACK_TIMEOUT = TimeValue.timeValueSeconds((long)30L);
    private TimeValue ackTimeout;

    protected AcknowledgedRequest(TimeValue masterNodeTimeout, TimeValue ackTimeout) {
        super(masterNodeTimeout);
        this.ackTimeout = Objects.requireNonNull(ackTimeout);
    }

    protected AcknowledgedRequest(StreamInput in) throws IOException {
        super(in);
        this.ackTimeout = in.readTimeValue();
    }

    public final Request ackTimeout(TimeValue ackTimeout) {
        this.ackTimeout = Objects.requireNonNull(ackTimeout);
        return (Request)this;
    }

    public final TimeValue ackTimeout() {
        return this.ackTimeout;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeTimeValue(this.ackTimeout);
    }

    @Override
    public ActionRequestValidationException validate() {
        return null;
    }

    public static final class Plain
    extends AcknowledgedRequest<Plain> {
        public Plain(StreamInput in) throws IOException {
            super(in);
        }

        public Plain(TimeValue masterNodeTimeout, TimeValue ackTimeout) {
            super(masterNodeTimeout, ackTimeout);
        }
    }
}

