/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.support;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.action.support.ActionFilter;
import org.elasticsearch.action.support.ActionFilterChain;
import org.elasticsearch.action.support.MappedActionFilter;
import org.elasticsearch.tasks.Task;

public class MappedActionFilters
implements ActionFilter {
    private final Map<String, List<MappedActionFilter>> filtersByAction;

    public MappedActionFilters(List<MappedActionFilter> mappedFilters) {
        HashMap<String, List> map = new HashMap<String, List>();
        for (MappedActionFilter filter : mappedFilters) {
            map.computeIfAbsent(filter.actionName(), k -> new ArrayList()).add(filter);
        }
        map.replaceAll((k, l) -> List.copyOf(l));
        this.filtersByAction = Map.copyOf(map);
    }

    @Override
    public int order() {
        return 0;
    }

    @Override
    public <Request extends ActionRequest, Response extends ActionResponse> void apply(Task task, String action, Request request, ActionListener<Response> listener, ActionFilterChain<Request, Response> outerChain) {
        MappedFilterChain<Request, Response> chain = new MappedFilterChain<Request, Response>(this.filtersByAction.getOrDefault(action, List.of()), outerChain);
        chain.proceed(task, action, request, listener);
    }

    private static class MappedFilterChain<Request extends ActionRequest, Response extends ActionResponse>
    implements ActionFilterChain<Request, Response> {
        final List<MappedActionFilter> filters;
        final ActionFilterChain<Request, Response> outerChain;
        int index = 0;

        MappedFilterChain(List<MappedActionFilter> filters, ActionFilterChain<Request, Response> outerChain) {
            this.filters = filters;
            this.outerChain = outerChain;
        }

        @Override
        public void proceed(Task task, String action, Request request, ActionListener<Response> listener) {
            if (this.index < this.filters.size()) {
                MappedActionFilter filter = this.filters.get(this.index++);
                filter.apply(task, action, request, listener, this);
            } else {
                this.outerChain.proceed(task, action, request, listener);
            }
        }
    }
}

