/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.search;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BiFunction;
import java.util.stream.Collectors;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.search.ClearScrollRequest;
import org.elasticsearch.action.search.ClearScrollResponse;
import org.elasticsearch.action.search.SearchContextIdForNode;
import org.elasticsearch.action.search.SearchScrollAsyncAction;
import org.elasticsearch.action.search.SearchTransportService;
import org.elasticsearch.action.search.TransportSearchHelper;
import org.elasticsearch.action.support.RefCountingRunnable;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.cluster.node.DiscoveryNodes;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.util.concurrent.ListenableFuture;
import org.elasticsearch.transport.Transport;
import org.elasticsearch.transport.TransportResponse;

public final class ClearScrollController
implements Runnable {
    private final DiscoveryNodes nodes;
    private final SearchTransportService searchTransportService;
    private final RefCountingRunnable refs = new RefCountingRunnable(this::finish);
    private final ActionListener<ClearScrollResponse> listener;
    private final AtomicBoolean hasFailed = new AtomicBoolean(false);
    private final AtomicInteger freedSearchContexts = new AtomicInteger(0);
    private final Logger logger;
    private final Runnable runner;

    ClearScrollController(ClearScrollRequest request, ActionListener<ClearScrollResponse> listener, DiscoveryNodes nodes, Logger logger, SearchTransportService searchTransportService) {
        this.nodes = nodes;
        this.logger = logger;
        this.searchTransportService = searchTransportService;
        this.listener = listener;
        List<String> scrollIds = request.getScrollIds();
        if (scrollIds.size() == 1 && "_all".equals(scrollIds.get(0))) {
            this.runner = this::cleanAllScrolls;
        } else {
            ArrayList contexts = new ArrayList();
            for (String scrollId : request.getScrollIds()) {
                SearchContextIdForNode[] context = TransportSearchHelper.parseScrollId(scrollId).getContext();
                Collections.addAll(contexts, context);
            }
            this.runner = () -> this.cleanScrollIds(contexts);
        }
    }

    @Override
    public void run() {
        this.runner.run();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void cleanAllScrolls() {
        try {
            for (final DiscoveryNode node : this.nodes) {
                try {
                    Transport.Connection connection = this.searchTransportService.getConnection(null, node);
                    this.searchTransportService.sendClearAllScrollContexts(connection, ActionListener.releaseAfter(new ActionListener<TransportResponse>(){

                        @Override
                        public void onResponse(TransportResponse response) {
                            ClearScrollController.this.onFreedContext(true);
                        }

                        @Override
                        public void onFailure(Exception e) {
                            ClearScrollController.this.onFailedFreedContext(e, node);
                        }
                    }, this.refs.acquire()));
                }
                catch (Exception e) {
                    this.onFailedFreedContext(e, node);
                }
            }
        }
        finally {
            this.refs.close();
        }
    }

    void cleanScrollIds(List<SearchContextIdForNode> contextIds) {
        SearchScrollAsyncAction.collectNodesAndRun(contextIds, this.nodes, this.searchTransportService, this.listener.delegateFailureAndWrap((l, lookup) -> {
            try {
                for (SearchContextIdForNode target : contextIds) {
                    DiscoveryNode node = (DiscoveryNode)lookup.apply(target.getClusterAlias(), target.getNode());
                    if (node == null) {
                        this.onFreedContext(false);
                        continue;
                    }
                    try {
                        Transport.Connection connection = this.searchTransportService.getConnection(target.getClusterAlias(), node);
                        this.searchTransportService.sendFreeContext(connection, target.getSearchContextId(), ActionListener.releaseAfter(ActionListener.wrap(freed -> this.onFreedContext(freed.isFreed()), e -> this.onFailedFreedContext((Throwable)e, node)), this.refs.acquire()));
                    }
                    catch (Exception e2) {
                        this.onFailedFreedContext(e2, node);
                    }
                }
            }
            finally {
                this.refs.close();
            }
        }));
    }

    private void onFreedContext(boolean freed) {
        if (freed) {
            this.freedSearchContexts.incrementAndGet();
        }
    }

    private void onFailedFreedContext(Throwable e, DiscoveryNode node) {
        this.logger.warn(() -> "Clear SC failed on node[" + String.valueOf(node) + "]", e);
        this.hasFailed.set(true);
    }

    private void finish() {
        this.listener.onResponse(new ClearScrollResponse(!this.hasFailed.get(), this.freedSearchContexts.get()));
    }

    public static void closeContexts(DiscoveryNodes nodes, SearchTransportService searchTransportService, Collection<SearchContextIdForNode> contextIds, ActionListener<Integer> listener) {
        Set<String> clusters = contextIds.stream().map(SearchContextIdForNode::getClusterAlias).filter(clusterAlias -> !Strings.isEmpty(clusterAlias)).collect(Collectors.toSet());
        ListenableFuture<BiFunction<String, String, DiscoveryNode>> lookupListener = new ListenableFuture<BiFunction<String, String, DiscoveryNode>>();
        if (clusters.isEmpty()) {
            lookupListener.onResponse((cluster, nodeId) -> nodes.get((String)nodeId));
        } else {
            searchTransportService.getRemoteClusterService().collectNodes(clusters, lookupListener);
        }
        lookupListener.addListener(listener.delegateFailure((l, nodeLookup) -> {
            AtomicInteger successes = new AtomicInteger();
            try (RefCountingRunnable refs = new RefCountingRunnable(() -> l.onResponse(successes.get()));){
                for (SearchContextIdForNode contextId : contextIds) {
                    DiscoveryNode node;
                    if (contextId.getNode() == null || (node = (DiscoveryNode)nodeLookup.apply(contextId.getClusterAlias(), contextId.getNode())) == null) continue;
                    try {
                        searchTransportService.sendFreeContext(searchTransportService.getConnection(contextId.getClusterAlias(), node), contextId.getSearchContextId(), refs.acquireListener().map(r -> {
                            if (r.isFreed()) {
                                successes.incrementAndGet();
                            }
                            return null;
                        }));
                    }
                    catch (Exception exception) {}
                }
            }
        }));
    }
}

