/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.admin.cluster.storedscripts;

import java.io.IOException;
import java.util.Objects;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.script.StoredScriptSource;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentObject;
import org.elasticsearch.xcontent.XContentBuilder;

public class GetStoredScriptResponse
extends ActionResponse
implements ToXContentObject {
    public static final ParseField _ID_PARSE_FIELD = new ParseField("_id", new String[0]);
    public static final ParseField FOUND_PARSE_FIELD = new ParseField("found", new String[0]);
    public static final ParseField SCRIPT = new ParseField("script", new String[0]);
    private final String id;
    private final StoredScriptSource source;

    public GetStoredScriptResponse(StreamInput in) throws IOException {
        this.source = in.readBoolean() ? new StoredScriptSource(in) : null;
        this.id = in.readString();
    }

    GetStoredScriptResponse(String id, StoredScriptSource source) {
        this.id = id;
        this.source = source;
    }

    public String getId() {
        return this.id;
    }

    public StoredScriptSource getSource() {
        return this.source;
    }

    public RestStatus status() {
        return this.source != null ? RestStatus.OK : RestStatus.NOT_FOUND;
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field(_ID_PARSE_FIELD.getPreferredName(), this.id);
        builder.field(FOUND_PARSE_FIELD.getPreferredName(), this.source != null);
        if (this.source != null) {
            builder.field(StoredScriptSource.SCRIPT_PARSE_FIELD.getPreferredName());
            this.source.toXContent(builder, params);
        }
        builder.endObject();
        return builder;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        if (this.source == null) {
            out.writeBoolean(false);
        } else {
            out.writeBoolean(true);
            this.source.writeTo(out);
        }
        out.writeString(this.id);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GetStoredScriptResponse that = (GetStoredScriptResponse)o;
        return Objects.equals(this.id, that.id) && Objects.equals(this.source, that.source);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.source);
    }
}

