/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.admin.cluster.snapshots.status;

import java.io.IOException;
import java.util.Objects;
import org.elasticsearch.TransportVersion;
import org.elasticsearch.action.admin.cluster.snapshots.status.SnapshotIndexShardStage;
import org.elasticsearch.action.admin.cluster.snapshots.status.SnapshotStats;
import org.elasticsearch.action.support.broadcast.BroadcastShardResponse;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.index.shard.ShardId;
import org.elasticsearch.index.snapshots.IndexShardSnapshotStatus;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentFragment;
import org.elasticsearch.xcontent.XContentBuilder;

public class SnapshotIndexShardStatus
extends BroadcastShardResponse
implements ToXContentFragment {
    private static final TransportVersion SNAPSHOT_INDEX_SHARD_STATUS_MISSING_STATS = TransportVersion.fromName("snapshot_index_shard_status_missing_stats");
    private final SnapshotIndexShardStage stage;
    private final SnapshotStats stats;
    private String nodeId;
    private String failure;
    private String description;

    public SnapshotIndexShardStatus(StreamInput in) throws IOException {
        super(in);
        this.stage = SnapshotIndexShardStage.fromValue(in.readByte());
        this.stats = new SnapshotStats(in);
        this.nodeId = in.readOptionalString();
        this.failure = in.readOptionalString();
        if (in.getTransportVersion().supports(SNAPSHOT_INDEX_SHARD_STATUS_MISSING_STATS)) {
            this.description = in.readOptionalString();
        }
    }

    SnapshotIndexShardStatus(ShardId shardId, SnapshotIndexShardStage stage) {
        super(shardId);
        this.stage = stage;
        this.stats = new SnapshotStats();
    }

    SnapshotIndexShardStatus(ShardId shardId, IndexShardSnapshotStatus.Copy indexShardStatus) {
        this(shardId, indexShardStatus, null);
    }

    SnapshotIndexShardStatus(ShardId shardId, IndexShardSnapshotStatus.Copy indexShardStatus, String nodeId) {
        super(shardId);
        this.stage = switch (indexShardStatus.getStage()) {
            case IndexShardSnapshotStatus.Stage.INIT -> SnapshotIndexShardStage.INIT;
            case IndexShardSnapshotStatus.Stage.STARTED -> SnapshotIndexShardStage.STARTED;
            case IndexShardSnapshotStatus.Stage.FINALIZE -> SnapshotIndexShardStage.FINALIZE;
            case IndexShardSnapshotStatus.Stage.DONE -> SnapshotIndexShardStage.DONE;
            case IndexShardSnapshotStatus.Stage.FAILURE -> SnapshotIndexShardStage.FAILURE;
            default -> throw new IllegalArgumentException("Unknown stage type " + String.valueOf((Object)indexShardStatus.getStage()));
        };
        this.stats = new SnapshotStats(indexShardStatus.getStartTime(), indexShardStatus.getTotalTime(), indexShardStatus.getIncrementalFileCount(), indexShardStatus.getTotalFileCount(), indexShardStatus.getProcessedFileCount(), indexShardStatus.getIncrementalSize(), indexShardStatus.getTotalSize(), indexShardStatus.getProcessedSize());
        this.failure = indexShardStatus.getFailure();
        this.nodeId = nodeId;
    }

    SnapshotIndexShardStatus(ShardId shardId, SnapshotIndexShardStage stage, SnapshotStats stats, String nodeId, String failure) {
        this(shardId, stage, stats, nodeId, failure, null);
    }

    SnapshotIndexShardStatus(ShardId shardId, SnapshotIndexShardStage stage, SnapshotStats stats, String nodeId, String failure, @Nullable String description) {
        super(shardId);
        this.stage = stage;
        this.stats = stats;
        this.nodeId = nodeId;
        this.failure = failure;
        this.description = description;
    }

    public static SnapshotIndexShardStatus forDoneButMissingStats(ShardId shardId, String description) {
        return new SnapshotIndexShardStatus(shardId, SnapshotIndexShardStage.DONE, SnapshotStats.forMissingStats(), null, null, Objects.requireNonNull(description));
    }

    public SnapshotIndexShardStage getStage() {
        return this.stage;
    }

    public SnapshotStats getStats() {
        return this.stats;
    }

    public String getNodeId() {
        return this.nodeId;
    }

    public String getFailure() {
        return this.failure;
    }

    @Nullable
    public String getDescription() {
        return this.description;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeByte(this.stage.value());
        this.stats.writeTo(out);
        out.writeOptionalString(this.nodeId);
        out.writeOptionalString(this.failure);
        if (out.getTransportVersion().supports(SNAPSHOT_INDEX_SHARD_STATUS_MISSING_STATS)) {
            out.writeOptionalString(this.description);
        }
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject(Integer.toString(this.getShardId().getId()));
        builder.field("stage", (Enum)this.getStage());
        builder.field("stats", (ToXContent)this.stats, params);
        if (this.getNodeId() != null) {
            builder.field("node", this.getNodeId());
        }
        if (this.getFailure() != null) {
            builder.field("reason", this.getFailure());
        }
        if (this.getDescription() != null) {
            builder.field("description", this.getDescription());
        }
        builder.endObject();
        return builder;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SnapshotIndexShardStatus that = (SnapshotIndexShardStatus)o;
        return this.stage == that.stage && Objects.equals(this.stats, that.stats) && Objects.equals(this.nodeId, that.nodeId) && Objects.equals(this.failure, that.failure) && Objects.equals(this.description, that.description);
    }

    public int hashCode() {
        int result = this.stage != null ? this.stage.hashCode() : 0;
        result = 31 * result + (this.stats != null ? this.stats.hashCode() : 0);
        result = 31 * result + (this.nodeId != null ? this.nodeId.hashCode() : 0);
        result = 31 * result + (this.failure != null ? this.failure.hashCode() : 0);
        result = 31 * result + (this.description != null ? this.description.hashCode() : 0);
        return result;
    }

    public String toString() {
        return Strings.toString((ToXContent)this, true, true);
    }

    static final class Fields {
        static final String STAGE = "stage";
        static final String REASON = "reason";
        static final String NODE = "node";
        static final String DESCRIPTION = "description";

        Fields() {
        }
    }
}

