/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.admin.cluster.desirednodes;

import java.io.IOException;
import java.util.Collections;
import java.util.Objects;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.support.master.MasterNodeReadRequest;
import org.elasticsearch.cluster.metadata.DesiredNodes;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentObject;
import org.elasticsearch.xcontent.XContentBuilder;

public class GetDesiredNodesAction
extends ActionType<Response> {
    public static final GetDesiredNodesAction INSTANCE = new GetDesiredNodesAction();
    public static final String NAME = "cluster:admin/desired_nodes/get";

    GetDesiredNodesAction() {
        super(NAME);
    }

    public static class Response
    extends ActionResponse
    implements ToXContentObject {
        private final DesiredNodes desiredNodes;

        public Response(DesiredNodes desiredNodes) {
            this.desiredNodes = desiredNodes;
        }

        public Response(StreamInput in) throws IOException {
            this.desiredNodes = DesiredNodes.readFrom(in);
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            this.desiredNodes.writeTo(out);
        }

        public DesiredNodes getDesiredNodes() {
            return this.desiredNodes;
        }

        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            return this.desiredNodes.toXContent(builder, (ToXContent.Params)new ToXContent.DelegatingMapParams(Collections.singletonMap("desired_nodes_x_content_context", DesiredNodes.CONTEXT_MODE_API), params));
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Response response = (Response)o;
            return Objects.equals(this.desiredNodes, response.desiredNodes);
        }

        public int hashCode() {
            return Objects.hash(this.desiredNodes);
        }
    }

    public static class Request
    extends MasterNodeReadRequest<Request> {
        public Request(TimeValue masterNodeTimeout) {
            super(masterNodeTimeout);
        }

        public Request(StreamInput in) throws IOException {
            super(in);
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
        }

        @Override
        public ActionRequestValidationException validate() {
            return null;
        }
    }
}

