/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ml.process;

import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;
import java.util.Objects;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.ElasticsearchParseException;
import org.elasticsearch.common.xcontent.LoggingDeprecationHandler;
import org.elasticsearch.xcontent.ConstructingObjectParser;
import org.elasticsearch.xcontent.DeprecationHandler;
import org.elasticsearch.xcontent.NamedXContentRegistry;
import org.elasticsearch.xcontent.XContentFactory;
import org.elasticsearch.xcontent.XContentParser;
import org.elasticsearch.xcontent.XContentType;

public class ProcessResultsParser<T> {
    private static final Logger logger = LogManager.getLogger(ProcessResultsParser.class);
    private final ConstructingObjectParser<T, Void> resultParser;
    private final NamedXContentRegistry namedXContentRegistry;

    public ProcessResultsParser(ConstructingObjectParser<T, Void> resultParser, NamedXContentRegistry namedXContentRegistry) {
        this.resultParser = Objects.requireNonNull(resultParser);
        this.namedXContentRegistry = Objects.requireNonNull(namedXContentRegistry);
    }

    public Iterator<T> parseResults(InputStream in) throws ElasticsearchParseException {
        try {
            XContentParser parser = XContentFactory.xContent((XContentType)XContentType.JSON).createParser(this.namedXContentRegistry, (DeprecationHandler)LoggingDeprecationHandler.INSTANCE, in);
            XContentParser.Token token = parser.nextToken();
            if (token != XContentParser.Token.START_ARRAY) {
                throw new ElasticsearchParseException("unexpected token [" + String.valueOf(token) + "]", new Object[0]);
            }
            return new ResultIterator(parser);
        }
        catch (IOException e) {
            throw new ElasticsearchParseException(e.getMessage(), (Throwable)e, new Object[0]);
        }
    }

    private class ResultIterator
    implements Iterator<T> {
        private final XContentParser parser;
        private XContentParser.Token token;

        private ResultIterator(XContentParser parser) {
            this.parser = parser;
            this.token = parser.currentToken();
        }

        @Override
        public boolean hasNext() {
            try {
                this.token = this.parser.nextToken();
            }
            catch (IOException e) {
                logger.debug("io error while parsing", (Throwable)e);
                return false;
            }
            if (this.token == XContentParser.Token.END_ARRAY) {
                return false;
            }
            if (this.token != XContentParser.Token.START_OBJECT) {
                logger.error("Expecting Json Field name token after the Start Object token");
                throw new ElasticsearchParseException("unexpected token [" + String.valueOf(this.token) + "]", new Object[0]);
            }
            return true;
        }

        @Override
        public T next() {
            return ProcessResultsParser.this.resultParser.apply(this.parser, null);
        }
    }
}

