/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ml.job.process;

import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.List;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.env.Environment;
import org.elasticsearch.xpack.core.XPackPlugin;

public final class ProcessBuilderUtils {
    public static final String ML_MODEL_CONF = "mlmodel.conf";

    private ProcessBuilderUtils() {
    }

    public static <T> void addIfNotNull(T object, String argKey, List<String> command) {
        if (object != null) {
            String param = argKey + String.valueOf(object);
            command.add(param);
        }
    }

    public static void addIfNotNull(TimeValue timeValue, String argKey, List<String> command) {
        ProcessBuilderUtils.addIfNotNull(timeValue == null ? null : Long.valueOf(timeValue.getSeconds()), argKey, command);
    }

    public static boolean modelConfigFilePresent(Environment env) {
        Path modelConfPath = XPackPlugin.resolveConfigFile((Environment)env, (String)ML_MODEL_CONF);
        return Files.isRegularFile(modelConfPath, new LinkOption[0]);
    }
}

