/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ml.inference.persistence;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.Objects;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.bytes.BytesArray;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.xcontent.ObjectParser;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentObject;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentParser;
import org.elasticsearch.xpack.core.ml.inference.TrainedModelConfig;
import org.elasticsearch.xpack.core.ml.inference.persistence.InferenceIndexConstants;
import org.elasticsearch.xpack.core.ml.utils.ExceptionsHelper;

public class TrainedModelDefinitionDoc
implements ToXContentObject {
    public static final String NAME = "trained_model_definition_doc";
    public static final ParseField DOC_NUM = new ParseField("doc_num", new String[0]);
    public static final ParseField DEFINITION = new ParseField("definition", new String[0]);
    public static final ParseField BINARY_DEFINITION = new ParseField("binary_definition", new String[0]);
    public static final ParseField COMPRESSION_VERSION = new ParseField("compression_version", new String[0]);
    public static final ParseField TOTAL_DEFINITION_LENGTH = new ParseField("total_definition_length", new String[0]);
    public static final ParseField DEFINITION_LENGTH = new ParseField("definition_length", new String[0]);
    public static final ParseField EOS = new ParseField("eos", new String[0]);
    public static final ObjectParser<Builder, Void> LENIENT_PARSER = TrainedModelDefinitionDoc.createParser(true);
    public static final ObjectParser<Builder, Void> STRICT_PARSER = TrainedModelDefinitionDoc.createParser(false);
    private final BytesReference binaryData;
    private final String modelId;
    private final int docNum;
    private final Long totalDefinitionLength;
    private final long definitionLength;
    private final int compressionVersion;
    private final boolean eos;

    private static ObjectParser<Builder, Void> createParser(boolean ignoreUnknownFields) {
        ObjectParser parser = new ObjectParser(NAME, ignoreUnknownFields, Builder::new);
        parser.declareString((a, b) -> {}, InferenceIndexConstants.DOC_TYPE);
        parser.declareString(Builder::setModelId, TrainedModelConfig.MODEL_ID);
        parser.declareString(Builder::setCompressedString, DEFINITION);
        parser.declareField(Builder::setBinaryData, (p, c) -> new BytesArray(p.binaryValue()), BINARY_DEFINITION, ObjectParser.ValueType.VALUE_OBJECT_ARRAY);
        parser.declareInt(Builder::setDocNum, DOC_NUM);
        parser.declareInt(Builder::setCompressionVersion, COMPRESSION_VERSION);
        parser.declareLong(Builder::setDefinitionLength, DEFINITION_LENGTH);
        parser.declareLong(Builder::setTotalDefinitionLength, TOTAL_DEFINITION_LENGTH);
        parser.declareBoolean(Builder::setEos, EOS);
        return parser;
    }

    public static Builder fromXContent(XContentParser parser, boolean lenient) throws IOException {
        return lenient ? (Builder)LENIENT_PARSER.parse(parser, null) : (Builder)STRICT_PARSER.parse(parser, null);
    }

    public static String docId(String modelId, int docNum) {
        return "trained_model_definition_doc-" + modelId + "-" + docNum;
    }

    public static int docNum(String modelId, String docId) {
        String prefix = "trained_model_definition_doc-" + modelId + "-";
        if (prefix.length() >= docId.length()) {
            return -1;
        }
        String numString = docId.substring(prefix.length());
        try {
            return Integer.parseInt(numString);
        }
        catch (NumberFormatException _ex) {
            return -1;
        }
    }

    public TrainedModelDefinitionDoc(BytesReference binaryData, String modelId, int docNum, Long totalDefinitionLength, long definitionLength, int compressionVersion, boolean eos) {
        this.binaryData = (BytesReference)ExceptionsHelper.requireNonNull((Object)binaryData, (ParseField)BINARY_DEFINITION);
        this.modelId = (String)ExceptionsHelper.requireNonNull((Object)modelId, (ParseField)TrainedModelConfig.MODEL_ID);
        if (docNum < 0) {
            throw new IllegalArgumentException("[doc_num] must be greater than or equal to 0");
        }
        this.docNum = docNum;
        if (totalDefinitionLength != null && totalDefinitionLength <= 0L) {
            throw new IllegalArgumentException("[total_definition_length] must be greater than 0");
        }
        this.totalDefinitionLength = totalDefinitionLength;
        if (definitionLength <= 0L) {
            throw new IllegalArgumentException("[definition_length] must be greater than 0");
        }
        this.definitionLength = definitionLength;
        this.compressionVersion = compressionVersion;
        this.eos = eos;
    }

    public BytesReference getBinaryData() {
        return this.binaryData;
    }

    public String getModelId() {
        return this.modelId;
    }

    public int getDocNum() {
        return this.docNum;
    }

    public Long getTotalDefinitionLength() {
        return this.totalDefinitionLength;
    }

    public long getDefinitionLength() {
        return this.definitionLength;
    }

    public int getCompressionVersion() {
        return this.compressionVersion;
    }

    public boolean isEos() {
        return this.eos;
    }

    public String getDocId() {
        return TrainedModelDefinitionDoc.docId(this.modelId, this.docNum);
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field(InferenceIndexConstants.DOC_TYPE.getPreferredName(), NAME);
        builder.field(TrainedModelConfig.MODEL_ID.getPreferredName(), this.modelId);
        builder.field(DOC_NUM.getPreferredName(), this.docNum);
        builder.field(DEFINITION_LENGTH.getPreferredName(), this.definitionLength);
        if (this.totalDefinitionLength != null) {
            builder.field(TOTAL_DEFINITION_LENGTH.getPreferredName(), this.totalDefinitionLength);
        }
        builder.field(COMPRESSION_VERSION.getPreferredName(), this.compressionVersion);
        builder.field(BINARY_DEFINITION.getPreferredName(), (ToXContent)this.binaryData);
        builder.field(EOS.getPreferredName(), this.eos);
        builder.endObject();
        return builder;
    }

    public String toString() {
        return Strings.toString((ToXContent)this);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TrainedModelDefinitionDoc that = (TrainedModelDefinitionDoc)o;
        return Objects.equals(this.modelId, that.modelId) && Objects.equals(this.docNum, that.docNum) && Objects.equals(this.definitionLength, that.definitionLength) && Objects.equals(this.totalDefinitionLength, that.totalDefinitionLength) && Objects.equals(this.compressionVersion, that.compressionVersion) && Objects.equals(this.eos, that.eos) && Objects.equals(this.binaryData, that.binaryData);
    }

    public int hashCode() {
        return Objects.hash(this.modelId, this.docNum, this.definitionLength, this.totalDefinitionLength, this.compressionVersion, this.binaryData, this.eos);
    }

    public static class Builder {
        private String modelId;
        private BytesReference binaryData;
        private int docNum;
        private Long totalDefinitionLength;
        private long definitionLength;
        private int compressionVersion;
        private boolean eos;

        public Builder setModelId(String modelId) {
            this.modelId = modelId;
            return this;
        }

        public Builder setCompressedString(String compressedString) {
            this.binaryData = new BytesArray(Base64.getDecoder().decode(compressedString.getBytes(StandardCharsets.UTF_8)));
            return this;
        }

        public Builder setBinaryData(BytesReference binaryData) {
            this.binaryData = binaryData;
            return this;
        }

        public Builder setDocNum(int docNum) {
            this.docNum = docNum;
            return this;
        }

        public Builder setTotalDefinitionLength(long totalDefinitionLength) {
            this.totalDefinitionLength = totalDefinitionLength;
            return this;
        }

        public Builder setDefinitionLength(long definitionLength) {
            this.definitionLength = definitionLength;
            return this;
        }

        public Builder setCompressionVersion(int compressionVersion) {
            this.compressionVersion = compressionVersion;
            return this;
        }

        public Builder setEos(boolean eos) {
            this.eos = eos;
            return this;
        }

        public TrainedModelDefinitionDoc build() {
            return new TrainedModelDefinitionDoc(this.binaryData, this.modelId, this.docNum, this.totalDefinitionLength, this.definitionLength, this.compressionVersion, this.eos);
        }
    }
}

