/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ml.inference.nlp.tokenizers;

import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import org.apache.lucene.analysis.CharArrayMap;
import org.elasticsearch.core.CheckedFunction;
import org.elasticsearch.core.Nullable;

public record CharSeqTokenTrieNode(CharArrayMap<CharSeqTokenTrieNode> children) {
    public static final CharSeqTokenTrieNode EMPTY = new CharSeqTokenTrieNode((CharArrayMap<CharSeqTokenTrieNode>)new CharArrayMap(0, false));

    public CharSeqTokenTrieNode(CharArrayMap<CharSeqTokenTrieNode> children) {
        this.children = Objects.requireNonNull(children);
    }

    boolean isLeaf() {
        return this.children.isEmpty();
    }

    public void clear() {
        if (this.isLeaf()) {
            return;
        }
        for (CharSeqTokenTrieNode c : this.children.values()) {
            c.clear();
        }
        this.children.clear();
    }

    @Nullable
    CharSeqTokenTrieNode getChild(CharSequence token) {
        return (CharSeqTokenTrieNode)this.children.get(token);
    }

    private void insert(List<String> tokens) {
        int currentTokenIndex;
        if (tokens.isEmpty()) {
            return;
        }
        CharSeqTokenTrieNode currentNode = this;
        for (currentTokenIndex = 0; currentTokenIndex < tokens.size() && currentNode.children.containsKey((CharSequence)tokens.get(currentTokenIndex)); ++currentTokenIndex) {
            currentNode = currentNode.getChild(tokens.get(currentTokenIndex));
        }
        while (currentTokenIndex < tokens.size()) {
            CharSeqTokenTrieNode childNode = new CharSeqTokenTrieNode((CharArrayMap<CharSeqTokenTrieNode>)new CharArrayMap(1, false));
            currentNode.children.put(tokens.get(currentTokenIndex), (Object)childNode);
            currentNode = childNode;
            ++currentTokenIndex;
        }
    }

    public static CharSeqTokenTrieNode build(Collection<String> tokens, CheckedFunction<String, List<String>, IOException> tokenizeFunction) throws IOException {
        CharSeqTokenTrieNode root = new CharSeqTokenTrieNode((CharArrayMap<CharSeqTokenTrieNode>)new CharArrayMap(1, false));
        for (String token : tokens) {
            List subTokens = (List)tokenizeFunction.apply((Object)token);
            root.insert(subTokens);
        }
        return root;
    }
}

