/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ml.inference.modelsize;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import org.apache.lucene.util.RamUsageEstimator;

final class SizeEstimatorHelper {
    private static final int STRING_SIZE = (int)RamUsageEstimator.shallowSizeOfInstance(String.class);

    private SizeEstimatorHelper() {
    }

    static long sizeOfString(int stringLength) {
        return RamUsageEstimator.alignObjectSize((long)((long)STRING_SIZE + (long)RamUsageEstimator.NUM_BYTES_ARRAY_HEADER + 2L * (long)stringLength));
    }

    static long sizeOfStringCollection(int[] stringSizes) {
        long shallow = RamUsageEstimator.alignObjectSize((long)((long)RamUsageEstimator.NUM_BYTES_ARRAY_HEADER + (long)RamUsageEstimator.NUM_BYTES_OBJECT_REF * (long)stringSizes.length));
        return shallow + Arrays.stream(stringSizes).mapToLong(SizeEstimatorHelper::sizeOfString).sum();
    }

    static long sizeOfDoubleArray(int arrayLength) {
        return RamUsageEstimator.alignObjectSize((long)((long)RamUsageEstimator.NUM_BYTES_ARRAY_HEADER + 8L * (long)arrayLength));
    }

    static long sizeOfHashMap(List<Long> sizeOfKeys, List<Long> sizeOfValues) {
        assert (sizeOfKeys.size() == sizeOfValues.size());
        long mapsize = RamUsageEstimator.shallowSizeOfInstance(HashMap.class);
        long mapEntrySize = RamUsageEstimator.shallowSizeOfInstance(Map.Entry.class);
        mapsize += Stream.concat(sizeOfKeys.stream(), sizeOfValues.stream()).mapToLong(Long::longValue).sum();
        mapsize += mapEntrySize * (long)sizeOfKeys.size();
        return mapsize += mapEntrySize * (long)sizeOfValues.size();
    }
}

