/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ml.dataframe.steps;

import java.time.Clock;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Supplier;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.ResourceNotFoundException;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.TaskOperationFailure;
import org.elasticsearch.action.admin.cluster.node.tasks.cancel.CancelTasksRequest;
import org.elasticsearch.action.admin.cluster.node.tasks.get.GetTaskRequest;
import org.elasticsearch.action.admin.cluster.node.tasks.list.ListTasksResponse;
import org.elasticsearch.action.admin.indices.create.CreateIndexResponse;
import org.elasticsearch.action.admin.indices.get.GetIndexAction;
import org.elasticsearch.action.admin.indices.get.GetIndexRequest;
import org.elasticsearch.action.bulk.BulkItemResponse;
import org.elasticsearch.action.support.ContextPreservingActionListener;
import org.elasticsearch.action.support.master.AcknowledgedResponse;
import org.elasticsearch.client.internal.Client;
import org.elasticsearch.client.internal.ParentTaskAssigningClient;
import org.elasticsearch.client.internal.node.NodeClient;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.util.concurrent.ThreadContext;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.index.IndexNotFoundException;
import org.elasticsearch.index.reindex.BulkByScrollResponse;
import org.elasticsearch.index.reindex.BulkByScrollTask;
import org.elasticsearch.index.reindex.ReindexAction;
import org.elasticsearch.index.reindex.ReindexRequest;
import org.elasticsearch.script.Script;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.tasks.TaskCancelledException;
import org.elasticsearch.tasks.TaskId;
import org.elasticsearch.tasks.TaskResult;
import org.elasticsearch.xpack.core.ClientHelper;
import org.elasticsearch.xpack.core.ml.dataframe.DataFrameAnalyticsConfig;
import org.elasticsearch.xpack.core.ml.job.messages.Messages;
import org.elasticsearch.xpack.core.ml.utils.ExceptionsHelper;
import org.elasticsearch.xpack.ml.MachineLearning;
import org.elasticsearch.xpack.ml.dataframe.DataFrameAnalyticsTask;
import org.elasticsearch.xpack.ml.dataframe.DestinationIndex;
import org.elasticsearch.xpack.ml.dataframe.steps.AbstractDataFrameAnalyticsStep;
import org.elasticsearch.xpack.ml.dataframe.steps.DataFrameAnalyticsStep;
import org.elasticsearch.xpack.ml.dataframe.steps.StepResponse;
import org.elasticsearch.xpack.ml.notifications.DataFrameAnalyticsAuditor;

public class ReindexingStep
extends AbstractDataFrameAnalyticsStep {
    private static final Logger LOGGER = LogManager.getLogger(ReindexingStep.class);
    private final ClusterService clusterService;
    private final String[] destIndexAllowedSettings;
    @Nullable
    private volatile Long reindexingTaskId;
    private volatile boolean isReindexingFinished;

    public ReindexingStep(ClusterService clusterService, NodeClient client, DataFrameAnalyticsTask task, DataFrameAnalyticsAuditor auditor, DataFrameAnalyticsConfig config, String[] destIndexAllowedSettings) {
        super(client, task, auditor, config);
        this.clusterService = Objects.requireNonNull(clusterService);
        this.destIndexAllowedSettings = Objects.requireNonNull(destIndexAllowedSettings);
    }

    @Override
    public DataFrameAnalyticsStep.Name name() {
        return DataFrameAnalyticsStep.Name.REINDEXING;
    }

    @Override
    protected void doExecute(ActionListener<StepResponse> listener) {
        this.task.getStatsHolder().getProgressTracker().updateReindexingProgress(1);
        ParentTaskAssigningClient parentTaskClient = this.parentTaskClient();
        ActionListener reindexCompletedListener = ActionListener.wrap(reindexResponse -> {
            if (this.isTaskStopping()) {
                LOGGER.debug("[{}] task is stopping. Stopping reindexing before it is finished.", (Object)this.config.getId());
                listener.onResponse((Object)new StepResponse(true));
                return;
            }
            ReindexingStep reindexingStep = this;
            synchronized (reindexingStep) {
                this.reindexingTaskId = null;
            }
            Exception reindexError = ReindexingStep.getReindexError(this.config.getId(), reindexResponse);
            if (reindexError != null) {
                listener.onFailure(reindexError);
                return;
            }
            this.auditor.info(this.config.getId(), Messages.getMessage((String)"Finished reindexing to destination index [{0}], took [{1}]", (Object[])new Object[]{this.config.getDest().getIndex(), reindexResponse.getTook()}));
            this.isReindexingFinished = true;
            this.task.getStatsHolder().getProgressTracker().updateReindexingProgress(100);
            LOGGER.debug("[{}] Reindex completed; created [{}]; retries [{}]", (Object)this.config.getId(), (Object)reindexResponse.getCreated(), (Object)reindexResponse.getBulkRetries());
            listener.onResponse((Object)new StepResponse(false));
        }, error -> {
            if (this.isTaskStopping() && ReindexingStep.isTaskCancelledException(error)) {
                LOGGER.debug(() -> "[" + this.config.getId() + "] Caught task cancelled exception while task is stopping", (Throwable)error);
                listener.onResponse((Object)new StepResponse(true));
            } else {
                listener.onFailure(error);
            }
        });
        ActionListener copyIndexCreatedListener = ActionListener.wrap(createIndexResponse -> {
            ReindexRequest reindexRequest = new ReindexRequest();
            reindexRequest.setRefresh(true);
            reindexRequest.setSourceIndices(this.config.getSource().getIndex());
            reindexRequest.setSourceQuery(this.config.getSource().getParsedQuery());
            reindexRequest.getSearchRequest().allowPartialSearchResults(false);
            reindexRequest.getSearchRequest().source().fetchSource(this.config.getSource().getSourceFiltering());
            reindexRequest.setDestIndex(this.config.getDest().getIndex());
            reindexRequest.setSlices(1);
            HashMap<String, Integer> counterValueParam = new HashMap<String, Integer>();
            counterValueParam.put("value", -1);
            reindexRequest.setScript(new Script(Script.DEFAULT_SCRIPT_TYPE, "painless", "ctx._source.ml__incremental_id = ++params.counter.value", Collections.singletonMap("counter", counterValueParam)));
            reindexRequest.setParentTask(this.getParentTaskId());
            ThreadContext threadContext = parentTaskClient.threadPool().getThreadContext();
            Supplier supplier = threadContext.newRestorableContext(false);
            try (ThreadContext.StoredContext ignore = threadContext.stashWithOrigin("ml");){
                ReindexingStep reindexingStep = this;
                synchronized (reindexingStep) {
                    block11: {
                        if (!this.isTaskStopping()) break block11;
                        LOGGER.debug("[{}] task is stopping. Stopping reindexing before it is finished.", (Object)this.config.getId());
                        listener.onResponse((Object)new StepResponse(true));
                        return;
                    }
                    LOGGER.info("[{}] Started reindexing", (Object)this.config.getId());
                    Task reindexTask = this.client.executeLocally((ActionType)ReindexAction.INSTANCE, (ActionRequest)reindexRequest, (ActionListener)new ContextPreservingActionListener(supplier, reindexCompletedListener));
                    this.reindexingTaskId = reindexTask.getId();
                }
                this.auditor.info(this.config.getId(), Messages.getMessage((String)"Started reindexing to destination index [{0}]", (Object[])new Object[]{this.config.getDest().getIndex()}));
            }
        }, arg_0 -> ((ActionListener)reindexCompletedListener).onFailure(arg_0));
        ActionListener destIndexListener = ActionListener.wrap(indexResponse -> {
            this.auditor.info(this.config.getId(), Messages.getMessage((String)"Using existing destination index [{0}]", (Object[])new Object[]{indexResponse.indices()[0]}));
            LOGGER.info("[{}] Using existing destination index [{}]", (Object)this.config.getId(), (Object)indexResponse.indices()[0]);
            DestinationIndex.updateMappingsToDestIndex((Client)parentTaskClient, this.config, indexResponse, (ActionListener<AcknowledgedResponse>)ActionListener.wrap(acknowledgedResponse -> copyIndexCreatedListener.onResponse(null), arg_0 -> ((ActionListener)copyIndexCreatedListener).onFailure(arg_0)));
        }, e -> {
            if (ExceptionsHelper.unwrapCause((Throwable)e) instanceof IndexNotFoundException) {
                this.auditor.info(this.config.getId(), Messages.getMessage((String)"Creating destination index [{0}]", (Object[])new Object[]{this.config.getDest().getIndex()}));
                LOGGER.info("[{}] Creating destination index [{}]", (Object)this.config.getId(), (Object)this.config.getDest().getIndex());
                DestinationIndex.createDestinationIndex((Client)parentTaskClient, Clock.systemUTC(), this.config, this.destIndexAllowedSettings, (ActionListener<CreateIndexResponse>)copyIndexCreatedListener);
            } else {
                copyIndexCreatedListener.onFailure(e);
            }
        });
        ClientHelper.executeWithHeadersAsync((Map)this.config.getHeaders(), (String)"ml", (Client)parentTaskClient, (ActionType)GetIndexAction.INSTANCE, (ActionRequest)new GetIndexRequest(MachineLearning.HARD_CODED_MACHINE_LEARNING_MASTER_NODE_TIMEOUT).indices(new String[]{this.config.getDest().getIndex()}), (ActionListener)destIndexListener);
    }

    private static Exception getReindexError(String jobId, BulkByScrollResponse reindexResponse) {
        if (!reindexResponse.getBulkFailures().isEmpty()) {
            LOGGER.error("[{}] reindexing encountered {} failures", (Object)jobId, (Object)reindexResponse.getBulkFailures().size());
            for (BulkItemResponse.Failure failure : reindexResponse.getBulkFailures()) {
                LOGGER.error("[{}] reindexing failure: {}", (Object)jobId, (Object)failure);
            }
            return ExceptionsHelper.serverError((String)("reindexing encountered " + reindexResponse.getBulkFailures().size() + " failures"));
        }
        if (reindexResponse.getReasonCancelled() != null) {
            LOGGER.error("[{}] reindex task got cancelled with reason [{}]", (Object)jobId, (Object)reindexResponse.getReasonCancelled());
            return ExceptionsHelper.serverError((String)("reindex task got cancelled with reason [" + reindexResponse.getReasonCancelled() + "]"));
        }
        if (reindexResponse.isTimedOut()) {
            LOGGER.error("[{}] reindex task timed out after [{}]", (Object)jobId, (Object)reindexResponse.getTook().getStringRep());
            return ExceptionsHelper.serverError((String)("reindex task timed out after [" + reindexResponse.getTook().getStringRep() + "]"));
        }
        return null;
    }

    private static boolean isTaskCancelledException(Exception error) {
        return ExceptionsHelper.unwrapCause((Throwable)error) instanceof TaskCancelledException || ExceptionsHelper.unwrapCause((Throwable)error.getCause()) instanceof TaskCancelledException;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void cancel(String reason, TimeValue timeout) {
        TaskId reindexTaskId = null;
        ReindexingStep reindexingStep = this;
        synchronized (reindexingStep) {
            if (this.reindexingTaskId != null) {
                reindexTaskId = new TaskId(this.clusterService.localNode().getId(), this.reindexingTaskId.longValue());
            }
        }
        if (reindexTaskId == null) {
            return;
        }
        LOGGER.debug("[{}] Cancelling reindex task [{}]", (Object)this.config.getId(), (Object)reindexTaskId);
        CancelTasksRequest cancelReindex = new CancelTasksRequest();
        cancelReindex.setTargetTaskId(reindexTaskId);
        cancelReindex.setReason(reason);
        cancelReindex.setTimeout(timeout);
        ListTasksResponse cancelReindexResponse = this.cancelTaskWithinMlOriginContext(cancelReindex);
        Throwable firstError = null;
        if (!cancelReindexResponse.getNodeFailures().isEmpty()) {
            firstError = ((ElasticsearchException)((Object)cancelReindexResponse.getNodeFailures().get(0))).getRootCause();
        }
        if (!cancelReindexResponse.getTaskFailures().isEmpty()) {
            firstError = ((TaskOperationFailure)cancelReindexResponse.getTaskFailures().get(0)).getCause();
        }
        if (firstError != null && !(ExceptionsHelper.unwrapCause((Throwable)firstError) instanceof ResourceNotFoundException)) {
            throw ExceptionsHelper.serverError((String)("[" + this.config.getId() + "] Error cancelling reindex task"), (Throwable)firstError);
        }
        LOGGER.debug("[{}] Reindex task was successfully cancelled", (Object)this.config.getId());
    }

    private ListTasksResponse cancelTaskWithinMlOriginContext(CancelTasksRequest cancelTasksRequest) {
        ThreadContext threadContext = this.client.threadPool().getThreadContext();
        try (ThreadContext.StoredContext ignore = threadContext.stashWithOrigin("ml");){
            ListTasksResponse listTasksResponse = (ListTasksResponse)this.client.admin().cluster().cancelTasks(cancelTasksRequest).actionGet();
            return listTasksResponse;
        }
    }

    @Override
    public void updateProgress(ActionListener<Void> listener) {
        this.getReindexTaskProgress((ActionListener<Integer>)ActionListener.wrap(reindexTaskProgress -> {
            this.task.getStatsHolder().getProgressTracker().updateReindexingProgress(Math.max(1, reindexTaskProgress));
            listener.onResponse(null);
        }, arg_0 -> listener.onFailure(arg_0)));
    }

    private void getReindexTaskProgress(ActionListener<Integer> listener) {
        TaskId reindexTaskId = this.getReindexTaskId();
        if (reindexTaskId == null) {
            listener.onResponse((Object)(this.isReindexingFinished ? 100 : 0));
            return;
        }
        GetTaskRequest getTaskRequest = new GetTaskRequest();
        getTaskRequest.setTaskId(reindexTaskId);
        this.client.admin().cluster().getTask(getTaskRequest, ActionListener.wrap(taskResponse -> {
            TaskResult taskResult = taskResponse.getTask();
            BulkByScrollTask.Status taskStatus = (BulkByScrollTask.Status)taskResult.getTask().status();
            int progress = (int)((double)taskStatus.getCreated() * 100.0 / (double)taskStatus.getTotal());
            listener.onResponse((Object)progress);
        }, error -> {
            if (ExceptionsHelper.unwrapCause((Throwable)error) instanceof ResourceNotFoundException) {
                listener.onResponse((Object)(this.isReindexingFinished ? 100 : 0));
            } else {
                listener.onFailure(error);
            }
        }));
    }

    @Nullable
    private TaskId getReindexTaskId() {
        try {
            return new TaskId(this.clusterService.localNode().getId(), this.reindexingTaskId.longValue());
        }
        catch (NullPointerException e) {
            return null;
        }
    }
}

