/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.core.expression;

import java.io.IOException;
import java.util.Objects;
import org.elasticsearch.TransportVersions;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.VersionId;
import org.elasticsearch.common.io.stream.NamedWriteableRegistry;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.xpack.esql.core.expression.Attribute;
import org.elasticsearch.xpack.esql.core.expression.NameId;
import org.elasticsearch.xpack.esql.core.expression.Nullability;
import org.elasticsearch.xpack.esql.core.expression.TypedAttribute;
import org.elasticsearch.xpack.esql.core.tree.NodeInfo;
import org.elasticsearch.xpack.esql.core.tree.Source;
import org.elasticsearch.xpack.esql.core.type.DataType;
import org.elasticsearch.xpack.esql.core.type.EsField;
import org.elasticsearch.xpack.esql.core.util.PlanStreamInput;
import org.elasticsearch.xpack.esql.core.util.PlanStreamOutput;

public class FieldAttribute
extends TypedAttribute {
    static final NamedWriteableRegistry.Entry ENTRY = new NamedWriteableRegistry.Entry(Attribute.class, "FieldAttribute", FieldAttribute::readFrom);
    private final String parentName;
    private final EsField field;
    protected FieldName lazyFieldName;

    public FieldAttribute(Source source, String name, EsField field) {
        this(source, null, name, field);
    }

    public FieldAttribute(Source source, @Nullable String parentName, String name, EsField field) {
        this(source, parentName, name, field, Nullability.TRUE, null, false);
    }

    public FieldAttribute(Source source, @Nullable String parentName, String name, EsField field, boolean synthetic) {
        this(source, parentName, name, field, Nullability.TRUE, null, synthetic);
    }

    public FieldAttribute(Source source, @Nullable String parentName, String name, EsField field, Nullability nullability, @Nullable NameId id, boolean synthetic) {
        super(source, name, field.getDataType(), nullability, id, synthetic);
        this.parentName = parentName;
        this.field = field;
    }

    private static FieldAttribute innerReadFrom(StreamInput in) throws IOException {
        Source source = Source.readFrom((StreamInput)((PlanStreamInput)in));
        String parentName = ((PlanStreamInput)in).readOptionalCachedString();
        String name = PlanStreamInput.readCachedStringWithVersionCheck(in);
        if (in.getTransportVersion().before((VersionId)TransportVersions.ESQL_FIELD_ATTRIBUTE_DROP_TYPE)) {
            DataType.readFrom(in);
        }
        Object field = EsField.readFrom(in);
        if (in.getTransportVersion().before((VersionId)TransportVersions.ESQL_FIELD_ATTRIBUTE_DROP_TYPE)) {
            in.readOptionalString();
        }
        Nullability nullability = (Nullability)in.readEnum(Nullability.class);
        NameId nameId = NameId.readFrom((StreamInput)((PlanStreamInput)in));
        boolean synthetic = in.readBoolean();
        return new FieldAttribute(source, parentName, name, (EsField)field, nullability, nameId, synthetic);
    }

    public void writeTo(StreamOutput out) throws IOException {
        if (((PlanStreamOutput)out).writeAttributeCacheHeader(this)) {
            Source.EMPTY.writeTo(out);
            ((PlanStreamOutput)out).writeOptionalCachedString(this.parentName);
            PlanStreamOutput.writeCachedStringWithVersionCheck(out, this.name());
            if (out.getTransportVersion().before((VersionId)TransportVersions.ESQL_FIELD_ATTRIBUTE_DROP_TYPE)) {
                this.dataType().writeTo(out);
            }
            this.field.writeTo(out);
            if (out.getTransportVersion().before((VersionId)TransportVersions.ESQL_FIELD_ATTRIBUTE_DROP_TYPE)) {
                out.writeOptionalString(null);
            }
            out.writeEnum((Enum)this.nullable());
            this.id().writeTo(out);
            out.writeBoolean(this.synthetic());
        }
    }

    public static FieldAttribute readFrom(StreamInput in) throws IOException {
        return (FieldAttribute)((PlanStreamInput)in).readAttributeWithCache(FieldAttribute::innerReadFrom);
    }

    public String getWriteableName() {
        return FieldAttribute.ENTRY.name;
    }

    @Override
    protected NodeInfo<FieldAttribute> info() {
        return NodeInfo.create(this, FieldAttribute::new, this.parentName, this.name(), this.field, this.nullable(), this.id(), this.synthetic());
    }

    public String parentName() {
        return this.parentName;
    }

    public FieldName fieldName() {
        if (this.lazyFieldName == null) {
            this.lazyFieldName = !(this.synthetic() || this.name().startsWith("$$")) ? new FieldName(this.name()) : new FieldName((String)(Strings.hasText((String)this.parentName) ? this.parentName + "." + this.field.getName() : this.field.getName()));
        }
        return this.lazyFieldName;
    }

    @Override
    public String name() {
        return super.name();
    }

    public EsField.Exact getExactInfo() {
        return this.field.getExactInfo();
    }

    public FieldAttribute exactAttribute() {
        EsField exactField = this.field.getExactField();
        if (!exactField.equals(this.field)) {
            return this.innerField(exactField);
        }
        return this;
    }

    private FieldAttribute innerField(EsField type) {
        return new FieldAttribute(this.source(), this.fieldName().string, this.name() + "." + type.getName(), type, this.nullable(), this.id(), this.synthetic());
    }

    @Override
    protected Attribute clone(Source source, String name, DataType type, Nullability nullability, NameId id, boolean synthetic) {
        return new FieldAttribute(source, this.parentName, name, this.field, nullability, id, synthetic);
    }

    @Override
    public Attribute withDataType(DataType type) {
        throw new UnsupportedOperationException("FieldAttribute obtains its type from the contained EsField.");
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.parentName, this.field);
    }

    @Override
    protected boolean innerEquals(Object o) {
        FieldAttribute other = (FieldAttribute)o;
        return super.innerEquals(other) && Objects.equals(this.parentName, other.parentName) && Objects.equals(this.field, other.field);
    }

    @Override
    protected String label() {
        return "f";
    }

    public EsField field() {
        return this.field;
    }

    public record FieldName(String string) {
    }
}

