/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.transform.action;

import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.metadata.Metadata;
import org.elasticsearch.cluster.metadata.ProjectMetadata;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.injection.guice.Inject;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.xpack.core.action.AbstractTransportSetResetModeAction;
import org.elasticsearch.xpack.core.action.SetResetModeActionRequest;
import org.elasticsearch.xpack.core.transform.TransformMetadata;

public class TransportSetTransformResetModeAction
extends AbstractTransportSetResetModeAction {
    @Inject
    public TransportSetTransformResetModeAction(TransportService transportService, ThreadPool threadPool, ClusterService clusterService, ActionFilters actionFilters) {
        super("cluster:internal/xpack/transform/reset_mode", transportService, threadPool, clusterService, actionFilters);
    }

    protected boolean isResetMode(ClusterState clusterState) {
        return TransformMetadata.getTransformMetadata((ClusterState)clusterState).resetMode();
    }

    protected String featureName() {
        return "transform";
    }

    protected ClusterState setState(ClusterState oldState, SetResetModeActionRequest request) {
        ProjectMetadata project = oldState.metadata().getDefaultProject();
        ProjectMetadata.Builder projectBuilder = ProjectMetadata.builder((ProjectMetadata)project);
        if (request.shouldDeleteMetadata()) {
            assert (!request.isEnabled());
            projectBuilder.removeCustom("transform");
        } else {
            TransformMetadata.Builder builder = TransformMetadata.Builder.from((TransformMetadata)((TransformMetadata)project.custom("transform"))).resetMode(request.isEnabled());
            projectBuilder.putCustom("transform", (Metadata.ProjectCustom)builder.build());
        }
        return ClusterState.builder((ClusterState)oldState).putProjectMetadata(projectBuilder.build()).build();
    }
}

