/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.transform.action;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.elasticsearch.xpack.core.transform.transforms.SourceConfig;
import org.elasticsearch.xpack.core.transform.transforms.SyncConfig;
import org.elasticsearch.xpack.transform.transforms.Function;

final class TransformConfigLinter {
    private static final String GROUP_BY_FIELDS_ARE_RUNTIME_FIELDS = "all the group-by fields are script-based runtime fields, this transform might run slowly, please check your configuration.";
    private static final String SYNC_FIELD_IS_RUNTIME_FIELD = "sync time field is a script-based runtime field, this transform might run slowly, please check your configuration.";
    private static final String NOT_OPTIMIZED = "could not find any optimizations for continuous execution, this transform might run slowly, please check your configuration.";

    static List<String> getWarnings(Function function, SourceConfig sourceConfig, SyncConfig syncConfig) {
        Function.ChangeCollector changeCollector;
        if (syncConfig == null) {
            return Collections.emptyList();
        }
        ArrayList<String> warnings = new ArrayList<String>();
        Map scriptBasedRuntimeFieldNames = sourceConfig.getScriptBasedRuntimeMappings();
        List<String> performanceCriticalFields = function.getPerformanceCriticalFields();
        if (performanceCriticalFields.stream().allMatch(scriptBasedRuntimeFieldNames::containsKey)) {
            warnings.add(GROUP_BY_FIELDS_ARE_RUNTIME_FIELDS);
        }
        if (scriptBasedRuntimeFieldNames.containsKey(syncConfig.getField())) {
            warnings.add(SYNC_FIELD_IS_RUNTIME_FIELD);
        }
        if (!(changeCollector = function.buildChangeCollector(syncConfig.getField())).isOptimized()) {
            warnings.add(NOT_OPTIMIZED);
        }
        return warnings;
    }

    private TransformConfigLinter() {
    }
}

